/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.AbstractModifierList;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.SyntaxModifier;
import com.streamscape.slex.lang.modifier.SyntaxToken;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class CompoundModifier
extends AbstractModifier<CompoundModifier> {
    List<SyntaxToken<?>> elements;

    public CompoundModifier() {
        super("", CompoundModifier.makeUniqueName("CompoundModifier"));
    }

    public CompoundModifier(boolean required) {
        this();
        this.setRequired(required);
    }

    public CompoundModifier(String name) {
        super("", name);
    }

    public CompoundModifier(String name, boolean required) {
        this(name);
        this.setRequired(required);
    }

    public CompoundModifier addModifier(AbstractModifier<?> modifier) {
        return this.add(modifier);
    }

    public CompoundModifier addModifierAt(int index, AbstractModifier<?> modifier) {
        return this.addAt(index, modifier);
    }

    public CompoundModifier addParameter(AbstractParameter<?> parameter) {
        return this.add(parameter);
    }

    public List<SyntaxToken<?>> getElements() {
        return this.elements;
    }

    public SyntaxToken<?> getElement(String name) {
        for (SyntaxToken<?> element : this.elements) {
            if (element.getName() == null || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public AbstractModifier<?> lookupModifier(String modifierName) {
        for (SyntaxToken<?> element : this.elements) {
            AbstractModifier<?> result;
            if (element instanceof AbstractModifierList) {
                result = ((AbstractModifierList)element).lookupModifier(modifierName);
                if (result == null) continue;
                return result;
            }
            if (element instanceof CompoundModifier) {
                result = ((CompoundModifier)element).lookupModifier(modifierName);
                if (result == null) continue;
                return result;
            }
            if (!(element instanceof AbstractModifier) || !element.getName().equals(modifierName)) continue;
            return (AbstractModifier)element;
        }
        return null;
    }

    protected CompoundModifier addAt(int index, SyntaxToken<?> element) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(index, element);
        return this;
    }

    protected CompoundModifier add(SyntaxToken<?> element) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(element);
        return this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder syntax = new StringBuilder();
        if (!this.isRequired()) {
            syntax.append("[");
        }
        for (SyntaxToken<?> element : this.elements) {
            if (!(element instanceof SyntaxModifier && SyntaxHint.appendSyntaxHint(syntax, (SyntaxModifier)element) || this.elements.get(0) == element)) {
                syntax.append(" ");
            }
            syntax.append(element.getSyntax(isFull));
        }
        if (!this.isRequired()) {
            syntax.append("]");
        }
        return syntax.toString();
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        parser.skipSpacesAndComments();
        if (parser.isAtEnd() && !this.isRequired()) {
            return null;
        }
        StatementValueList parsedStatementList = new StatementValueList("templist");
        int elementsProcessed = 0;
        try {
            for (SyntaxToken<?> element : this.elements) {
                element.parse(parsedStatementList, parser);
                if (!(element instanceof AbstractParameter) && (!(element instanceof Modifier) || ((Modifier)element).getParameters() == null || ((Modifier)element).getParameters().size() <= 0)) continue;
                ++elementsProcessed;
            }
        }
        catch (DSLParameterValidationException e) {
            throw e;
        }
        catch (DSLSyntaxValidationException e) {
            parser.seek(startPosition);
            if (elementsProcessed > 0) {
                e.setErrorLevel(DSLSyntaxValidationException.ErrorLevel.BLOCK_MODIFIER_HEADER_PARSED);
                throw e;
            }
            if (this.isRequired()) {
                if (e.getErrorLevel() == DSLSyntaxValidationException.ErrorLevel.BLOCK_MODIFIER_HEADER_PARSED) {
                    throw e;
                }
                throw new DSLSyntaxValidationException("Expected syntax '" + this.getSyntax(true) + "' , after '" + parser.getProcessedScript() + "'.", e);
            }
            parsedStatementList.clear();
        }
        statement.addAll(parsedStatementList);
        return null;
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        TrieNode childNode = node;
        TrieNode lastRequired = null;
        for (SyntaxToken<?> element : this.elements) {
            childNode = element.buildTrie(childNode);
            if (element.isRequired()) {
                lastRequired = childNode;
                continue;
            }
            if (element.isRequired() || lastRequired == null) continue;
            lastRequired.setBackwardLink(node);
        }
        if (childNode != node && !this.isRequired()) {
            childNode.setBackwardLink(node);
            childNode = node;
        }
        return childNode;
    }
}

