/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.AbstractModifierList;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.SyntaxModifier;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.LinkedList;

public class ChoiceModifier
extends AbstractModifierList<ChoiceModifier> {
    public ChoiceModifier() {
        super(ChoiceModifier.makeUniqueName("ChoiceModifier"));
    }

    public ChoiceModifier(String name) {
        super(name);
    }

    public ChoiceModifier(boolean required) {
        super(ChoiceModifier.makeUniqueName("ChoiceModifier"), required);
    }

    public ChoiceModifier(String name, boolean required) {
        super(name, required);
    }

    public ChoiceModifier addPossibleValue(String value) {
        return this.addPossibleValue(value, value);
    }

    public ChoiceModifier addPossibleValue(String value, String name) {
        return (ChoiceModifier)this.addModifier((AbstractModifier)new Modifier(value).setName(name));
    }

    public ChoiceModifier addPossibleValues(Class<?> enumClass) {
        if (enumClass != null) {
            for (Object c : enumClass.getEnumConstants()) {
                this.addPossibleValue(c.toString());
            }
        }
        return this;
    }

    public ChoiceModifier addPossibleValuesExcept(Class<?> enumClass, Object ... excepted) {
        if (enumClass != null) {
            for (Object c : enumClass.getEnumConstants()) {
                boolean except = false;
                for (Object e : excepted) {
                    if (!c.equals(e)) continue;
                    except = true;
                }
                if (except) continue;
                this.addPossibleValue(c.toString());
            }
        }
        return this;
    }

    public ChoiceModifier addPossibleValues(String ... values) {
        for (String value : values) {
            this.addPossibleValue(value);
        }
        return this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder syntax = new StringBuilder();
        if (!this.isRequired()) {
            syntax.append("[");
        }
        if (this.modifiers.size() > 1) {
            syntax.append("{");
        }
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (i > 0) {
                syntax.append(" | ");
            }
            SyntaxHint.appendSyntaxHint(syntax, (SyntaxModifier)this.modifiers.get(i));
            syntax.append(((AbstractModifier)this.modifiers.get(i)).getSyntax(isFull));
        }
        if (this.modifiers.size() > 1) {
            syntax.append("}");
        }
        if (!this.isRequired()) {
            syntax.append("]");
        }
        return syntax.toString();
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        LinkedList<AbstractModifier> sortedModifiers = new LinkedList<AbstractModifier>();
        int first = 0;
        for (AbstractModifier modifier : this.modifiers) {
            if (modifier.getToken() == null || modifier.getToken().length() == 0) {
                sortedModifiers.add(modifier);
                continue;
            }
            sortedModifiers.add(first++, modifier);
        }
        DSLParameterValidationException firstParameterValidationException = null;
        DSLSyntaxValidationException firstSyntaxValidationException = null;
        for (int i = 0; i < sortedModifiers.size(); ++i) {
            AbstractModifier modifier = (AbstractModifier)sortedModifiers.get(i);
            int startPosition = parser.getPosition();
            try {
                block18: {
                    StatementValue value;
                    StatementValueList choiceStatement;
                    block17: {
                        choiceStatement = new StatementValueList("ChoiceStatement");
                        value = modifier.parse(choiceStatement, parser);
                        if (!this.isLastModifier()) break block17;
                        parser.skipSpacesAndComments();
                        if (!parser.isAtEnd() && i < sortedModifiers.size() - 1) break block18;
                    }
                    if (value != null) {
                        StatementValue value1 = (StatementValue)value.clone();
                        value1.setName(this.getName());
                        value1.setPrintable(false);
                        statement.addValue(value1);
                    }
                    for (int j = 0; j < choiceStatement.getValuesCount(); ++j) {
                        statement.addValue(choiceStatement.getValue(j));
                    }
                    return value;
                }
                parser.seek(startPosition);
                continue;
            }
            catch (DSLParameterValidationException exception) {
                CompoundModifier compoundModifier;
                parser.seek(startPosition);
                if (modifier instanceof CompoundModifier && (compoundModifier = (CompoundModifier)modifier).getElements().size() > 0 && compoundModifier.getElements().get(0) instanceof AbstractModifier) {
                    modifier = (AbstractModifier)compoundModifier.getElements().get(0);
                }
                if (modifier.getToken() != null && modifier.getToken().length() != 0) {
                    throw exception;
                }
                if (firstParameterValidationException != null) continue;
                firstParameterValidationException = exception;
                continue;
            }
            catch (DSLSyntaxValidationException exception) {
                parser.seek(startPosition);
                if (exception.getErrorLevel() != DSLSyntaxValidationException.ErrorLevel.BLOCK_MODIFIER_HEADER_PARSED || firstSyntaxValidationException != null) continue;
                firstSyntaxValidationException = exception;
            }
        }
        if (this.isRequired()) {
            if (firstParameterValidationException != null) {
                throw firstParameterValidationException;
            }
            if (firstSyntaxValidationException != null) {
                throw firstSyntaxValidationException;
            }
        }
        if (this.isRequired()) {
            throw new DSLSyntaxValidationException("Expected modifier with syntax '" + this.getSyntax(true) + "' instead of '" + parser.getRemainingScript() + "', after '" + parser.getProcessedScript() + "'.");
        }
        return new StatementModifierValue(this.getName(), false);
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        ArrayList<TrieNode> choices = new ArrayList<TrieNode>();
        for (AbstractModifier modifier : this.modifiers) {
            choices.add(modifier.buildTrie(node));
        }
        TrieNode aggregateNode = null;
        for (TrieNode choice : choices) {
            if (aggregateNode == null) {
                aggregateNode = new TrieNode(choice, ' ');
                aggregateNode.setAggregate(true);
                choice.appendChild(aggregateNode);
                continue;
            }
            choice.appendChild(aggregateNode);
            aggregateNode.addParent(choice);
        }
        if (aggregateNode != null) {
            aggregateNode.setData(this);
            if (!this.isRequired()) {
                aggregateNode.setBackwardLink(node);
                return node;
            }
            return aggregateNode;
        }
        return node;
    }
}

