/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.omf.json.utils.MemoryRefStack;
import com.streamscape.slex.lang.DSLDefinitionException;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidator;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.modifier.SyntaxModifier;
import com.streamscape.slex.lang.modifier.SyntaxToken;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BlockModifier
extends AbstractModifier<BlockModifier> {
    private List<AbstractModifier<?>> modifiers = new ArrayList();
    private char openBracket = (char)40;
    private char closeBracket = (char)41;

    public BlockModifier(String token) {
        super(token);
    }

    public BlockModifier(String token, String name) {
        super(token, name);
    }

    public BlockModifier(String token, String name, boolean required) {
        super(token, name, required);
    }

    public BlockModifier setBrackets(char openBracket, char closeBracket) {
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
        return this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder builder = new StringBuilder();
        if (!this.isRequired()) {
            builder.append("[");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getToken())) {
            builder.append(this.isDisplayInLowerCase() ? this.getToken().toLowerCase() : this.getToken()).append(" ");
        }
        builder.append(this.openBracket);
        builder.append(this.getInsideBlockSyntax());
        builder.append(this.closeBracket);
        if (!this.isRequired()) {
            builder.append("]");
        }
        return builder.toString();
    }

    public String getInsideBlockSyntax() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            if (!SyntaxHint.appendSyntaxHint(builder, (SyntaxModifier)this.modifiers.get(i)) && i > 0) {
                builder.append("\n ");
            }
            builder.append(this.modifiers.get(i).getSyntax());
        }
        return builder.toString();
    }

    public BlockModifier addModifier(AbstractModifier<?> modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        String line;
        StatementValue svalue = super.parse(statement, parser);
        if (!svalue.isPresent()) {
            return svalue;
        }
        if (this.modifiers.size() > 0) {
            this.modifiers.get(this.modifiers.size() - 1).setIsLastModifier(true);
        }
        statement.removeValue(this.getName());
        int startPosition = parser.getPosition();
        String blockScript = parser.nextTokenIn(this.openBracket, this.closeBracket);
        if (blockScript == null) {
            parser.seek(startPosition);
            if (!this.isRequired()) {
                return new StatementModifierValue(this.getName(), false);
            }
            throw new DSLSyntaxValidationException("Expected '" + this.getSyntax() + "', after '" + parser.getProcessedScript() + "'.", DSLSyntaxValidationException.ErrorLevel.BLOCK_MODIFIER_HEADER_PARSED);
        }
        blockScript = blockScript.trim();
        StatementBlockValue block = new StatementBlockValue(this.getName(), this.getToken());
        if (blockScript.length() == 0) {
            if (this.modifiers.size() == 1 && !this.modifiers.get(0).isRequired()) {
                return block;
            }
            throw new DSLSyntaxValidationException("Expected block with syntax '" + this.getInsideBlockSyntax() + "', after '" + parser.getProcessedScript() + "'.");
        }
        ScriptParser blockParser = new ScriptParser(blockScript + ",");
        ArrayList notProcessedModifiers = new ArrayList(this.modifiers);
        while ((line = blockParser.nextTokenWithEnd(',')) != null) {
            StatementValueList statementValueList = new StatementValueList("StatementValueList");
            for (AbstractModifier abstractModifier : notProcessedModifiers) {
                try {
                    abstractModifier.parse(statementValueList, new ScriptParser(line));
                    if (statementValueList.size() <= 0) continue;
                    statementValueList.setName(abstractModifier.getName());
                    if (abstractModifier instanceof RepeatableModifier) break;
                    notProcessedModifiers.remove(abstractModifier);
                    break;
                }
                catch (DSLParameterValidationException exception) {
                    throw new DSLParameterValidationException("Syntax error in line: '" + line + "', cause: " + exception.getMessage());
                }
                catch (DSLSyntaxValidationException exception) {
                    if (statementValueList.getValuesCount() <= 0 && !abstractModifier.isLastModifier() && (abstractModifier instanceof RepeatableModifier || !abstractModifier.isRequired())) continue;
                    throw new DSLParameterValidationException("Syntax error in line: '" + line + "', cause: " + exception.getMessage());
                }
            }
            if (statementValueList.getValuesCount() == 0) {
                throw new DSLSyntaxValidationException("Syntax error in line: '" + line + "', in block (" + blockScript + "), block syntax: '" + this.getInsideBlockSyntax() + "'.", DSLSyntaxValidationException.ErrorLevel.BLOCK_MODIFIER_HEADER_PARSED);
            }
            block.addStatementValueList(statementValueList);
        }
        if (!blockParser.isAtEnd()) {
            throw new DSLSyntaxValidationException("Unexpected end of block: '" + blockParser.getRemainingScript() + "', in block (" + blockScript + "), block syntax: '" + this.getInsideBlockSyntax() + "'.", DSLSyntaxValidationException.ErrorLevel.BLOCK_MODIFIER_HEADER_PARSED);
        }
        return statement.addBlock(block);
    }

    public void validate(MemoryRefStack<Object> stack) throws DSLDefinitionException {
        HashSet<String> names = new HashSet<String>();
        for (SyntaxToken syntaxToken : this.modifiers) {
            DSLSyntaxValidator.addNameOrThrowException(names, syntaxToken);
            if (stack.contains(syntaxToken)) continue;
            stack.push(syntaxToken);
            HashSet<String> names1 = new HashSet<String>();
            DSLSyntaxValidator.validate(names1, stack, syntaxToken);
            stack.pop();
        }
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        TrieNode parent = node;
        while (parent != null) {
            if (parent.getData() == this) {
                return node;
            }
            parent = parent.getParent() != null ? parent.getParent()[0] : null;
        }
        node = super.buildTrie(node);
        TrieNode superModifierBackwardLink = node.getBackwardLink();
        node.setBackwardLink(null);
        node = node.add(String.valueOf(this.openBracket));
        node.setData(this);
        TrieNode startBlockNode = node;
        ArrayList<TrieNode> childNodes = new ArrayList<TrieNode>();
        for (AbstractModifier<?> modifier : this.modifiers) {
            node = modifier.buildTrie(startBlockNode);
            childNodes.add(node);
        }
        for (int i = 0; i < childNodes.size(); ++i) {
            TrieNode commaNode = ((TrieNode)childNodes.get(0)).add(",");
            commaNode.setData((SyntaxToken)this.modifiers.get(i));
            if (commaNode.getData() instanceof RepeatableModifier) {
                commaNode.setRepeatable(true);
            }
            commaNode.setBackwardLink(startBlockNode);
        }
        TrieNode closeBracketNode = null;
        for (TrieNode childNode : childNodes) {
            if (closeBracketNode == null) {
                closeBracketNode = childNode.add(this.closeBracket + " ");
                continue;
            }
            childNode.appendChild(closeBracketNode);
        }
        closeBracketNode.setData(this);
        closeBracketNode.setBackwardLink(superModifierBackwardLink);
        return closeBracketNode;
    }
}

