/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class AbstractModifierList<T>
extends AbstractModifier<T> {
    protected List<AbstractModifier<?>> modifiers = new ArrayList();

    public AbstractModifierList() {
        super("", "AbstractModifierList");
    }

    public AbstractModifierList(String name) {
        super("", name);
    }

    public AbstractModifierList(String name, boolean required) {
        super("", name, required);
    }

    @Override
    public T setDisplayInLowerCase(boolean displayInLowerCase) {
        super.setDisplayInLowerCase(displayInLowerCase);
        for (AbstractModifier<?> modifier : this.modifiers) {
            modifier.setDisplayInLowerCase(displayInLowerCase);
        }
        return (T)this;
    }

    public T addModifier(AbstractModifier<?> modifier) {
        modifier.setDisplayInLowerCase(this.isDisplayInLowerCase());
        this.modifiers.add(modifier);
        return (T)this;
    }

    public T addParameter(AbstractParameter<?> parameter) {
        this.modifiers.add((AbstractModifier)new Modifier().addParameter(parameter));
        return (T)this;
    }

    public T removeModifier(AbstractModifier<?> modifier) {
        this.modifiers.remove(modifier);
        return (T)this;
    }

    public AbstractModifier<?> getModifier(String name) {
        for (AbstractModifier<?> modifier : this.modifiers) {
            if (!modifier.getName().equals(name)) continue;
            return modifier;
        }
        return null;
    }

    public List<AbstractModifier<?>> getModifiers() {
        ArrayList result = new ArrayList();
        result.addAll(this.modifiers);
        return result;
    }

    public boolean existsModifier(String modifierName) {
        for (AbstractModifier<?> modifier : this.modifiers) {
            if (!modifier.getName().equals(modifierName)) continue;
            return true;
        }
        return false;
    }

    public AbstractModifier<?> lookupModifier(String modifierName) {
        for (AbstractModifier<?> modifier : this.modifiers) {
            AbstractModifier<?> result;
            if (modifier instanceof AbstractModifierList) {
                result = ((AbstractModifierList)modifier).lookupModifier(modifierName);
                if (result == null) continue;
                return result;
            }
            if (modifier instanceof CompoundModifier) {
                result = ((CompoundModifier)modifier).lookupModifier(modifierName);
                if (result == null) continue;
                return result;
            }
            if (!modifier.getName().equals(modifierName)) continue;
            return modifier;
        }
        return null;
    }

    public boolean hasModifiers() {
        return !this.modifiers.isEmpty();
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        if (this.modifiers == null) {
            return "";
        }
        StringBuilder syntaxBuff = new StringBuilder();
        for (AbstractModifier<?> modifier : this.modifiers) {
            String hint = SyntaxHint.getSyntaxHintForToken(modifier);
            if (hint == null) {
                hint = "\n   ";
            }
            syntaxBuff.append(hint);
            StringBuilder modifierSyntaxBuilder = new StringBuilder(modifier.getSyntax(isFull));
            int position = 0;
            while ((position = modifierSyntaxBuilder.indexOf("\n", position)) > 0) {
                modifierSyntaxBuilder.replace(position, position + 1, hint);
                ++position;
            }
            syntaxBuff.append((CharSequence)modifierSyntaxBuilder);
        }
        return syntaxBuff.toString();
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        if (this.modifiers.size() > 0) {
            this.modifiers.get(this.modifiers.size() - 1).setIsLastModifier(true);
        }
        for (AbstractModifier<?> modifier : this.modifiers) {
            modifier.parse(statement, parser);
        }
        return statement;
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        for (AbstractModifier<?> modifier : this.modifiers) {
            node = modifier.buildTrie(node);
        }
        return node;
    }
}

