/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractSyntaxToken;
import com.streamscape.slex.lang.modifier.SyntaxModifier;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public abstract class AbstractModifier<T>
extends AbstractSyntaxToken<T>
implements SyntaxModifier<T> {
    private String token;
    private SyntaxHint syntaxHint;
    private String postfix;
    private boolean noSpacesAfter = false;
    private boolean includeToDefinition = false;
    private boolean isLastModifier = false;
    private String alias;
    private boolean hiddenAlias = false;
    private boolean displayInLowerCase = true;
    private transient List<String> tokens;

    protected AbstractModifier(String token) {
        this(token, token.trim());
    }

    protected AbstractModifier(String token, String name) {
        super(name);
        this.token = token.trim();
        this.initTokens();
    }

    protected AbstractModifier(String token, String name, boolean required) {
        this(token, name);
        this.setRequired(required);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public T setPostfix(String postfix) {
        this.postfix = postfix;
        return (T)this;
    }

    @Override
    public String getPostfix() {
        return this.postfix;
    }

    public T setAlias(String alias) {
        this.alias = alias;
        return (T)this;
    }

    public T setHiddenAlias(String alias) {
        this.setAlias(alias);
        this.hiddenAlias = true;
        return (T)this;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isDisplayInLowerCase() {
        return this.displayInLowerCase;
    }

    public T setDisplayInLowerCase(boolean displayInLowerCase) {
        this.displayInLowerCase = displayInLowerCase;
        return (T)this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        Object p = this.noSpacesAfter ? this.postfix : " " + this.postfix;
        Object printToken = this.token;
        if (this.displayInLowerCase) {
            printToken = ((String)printToken).toLowerCase();
        }
        if (this.alias != null && !this.hiddenAlias) {
            printToken = (String)printToken + " | " + this.alias.toLowerCase();
        }
        if (this.postfix != null) {
            printToken = (String)printToken + (String)p;
        }
        if (this.isRequired()) {
            return printToken;
        }
        return "[" + (String)printToken + "]";
    }

    @Override
    public T setSyntaxHint(SyntaxHint syntaxHint) {
        this.syntaxHint = syntaxHint;
        return (T)this;
    }

    public T setSyntaxHintSpace() {
        return this.setSyntaxHint(SyntaxHint.SPACE);
    }

    @Override
    public SyntaxHint getSyntaxHint() {
        return this.syntaxHint;
    }

    @Override
    public T setIncludeToDefinition(boolean includeToDefinition) {
        this.includeToDefinition = includeToDefinition;
        return (T)this;
    }

    @Override
    public boolean getIncludeToDefinition() {
        return this.includeToDefinition;
    }

    @Override
    public T setNoSpacesAfter() {
        this.noSpacesAfter = true;
        return (T)this;
    }

    @Override
    public boolean isNoSpacesAfter() {
        return this.noSpacesAfter;
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        if (this.getToken() == null || this.getToken().length() == 0) {
            return new StatementModifierValue(this.getName());
        }
        int startPosition = parser.getPosition();
        boolean aliased = false;
        if (this.alias != null) {
            parser.skipSpacesAndComments();
            String readAlias = parser.nextToken();
            if (readAlias != null && readAlias.equalsIgnoreCase(this.alias)) {
                aliased = true;
            } else {
                parser.seek(startPosition);
            }
        }
        if (!aliased) {
            Iterator<String> iter = this.getTokens().iterator();
            while (iter.hasNext()) {
                String nextToken;
                int startPosition1 = parser.getPosition();
                String t = iter.next();
                if (iter.hasNext() || !this.noSpacesAfter) {
                    if (t.startsWith("=")) {
                        parser.skipSpacesAndComments();
                        nextToken = parser.next(t.length());
                    } else {
                        nextToken = parser.nextToken();
                    }
                } else {
                    nextToken = parser.next(t.length());
                }
                if (nextToken != null && nextToken.equalsIgnoreCase(t)) continue;
                if (!this.isRequired()) {
                    parser.seek(startPosition);
                    return new StatementModifierValue(this.getName(), false);
                }
                String processedScript = parser.getBlock(0, startPosition1);
                parser.seek(startPosition);
                if (nextToken == null) {
                    throw new DSLSyntaxValidationException("Unexpected end of statement. Expected token '" + t + "' after '" + processedScript + "'.");
                }
                throw new DSLSyntaxValidationException("Expected token '" + t + "' instead of '" + nextToken + "', after '" + processedScript + "'.");
            }
        }
        if (this.postfix != null && this.postfix.length() > 0) {
            startPosition = parser.getPosition();
            String nextToken = this.noSpacesAfter ? parser.next(this.postfix.length()) : parser.nextToken();
            if (nextToken == null || !nextToken.equalsIgnoreCase(this.postfix)) {
                parser.seek(startPosition);
                throw new DSLSyntaxValidationException("Expected '" + this.postfix + "' instead of '" + nextToken + "', after '" + parser.getProcessedScript() + "'.");
            }
        }
        StatementModifierValue modifierValue = statement.addModifier(this.getName(), this.getToken());
        modifierValue.setPostfix(this.postfix);
        return modifierValue;
    }

    protected void initTokens() {
        this.tokens = Arrays.asList(this.token.split(" "));
    }

    protected List<String> getTokens() {
        if (this.tokens == null) {
            this.initTokens();
        }
        return this.tokens;
    }

    public String toString() {
        return this.getSyntax();
    }

    public void setIsLastModifier(boolean isLastModifier) {
        this.isLastModifier = isLastModifier;
    }

    public boolean isLastModifier() {
        return this.isLastModifier;
    }

    protected static String makeUniqueName(String name) {
        return name + "_" + UUID.randomUUID().toString();
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        TrieNode tokenNode = node;
        if (this.token != null && this.token.length() > 0) {
            String t = this.token;
            if (this.isDisplayInLowerCase()) {
                t = this.token.toLowerCase();
            }
            tokenNode = node.add(t);
        }
        if (tokenNode == node) {
            return node;
        }
        TrieNode aliasNode = null;
        if (this.alias != null && this.alias.length() > 0) {
            aliasNode = node.add(this.alias);
        }
        if (this.postfix != null && this.postfix.length() > 0) {
            if (this.noSpacesAfter) {
                if (aliasNode != null) {
                    tokenNode = tokenNode.add(this.postfix.substring(0, 1));
                    aliasNode.appendChild(tokenNode);
                    if (this.postfix.length() > 1) {
                        tokenNode = tokenNode.add(this.postfix.substring(1));
                    }
                } else {
                    tokenNode = tokenNode.add(this.postfix);
                }
            } else {
                tokenNode = tokenNode.add(" ");
                if (aliasNode != null) {
                    aliasNode.appendChild(tokenNode);
                }
                tokenNode = tokenNode.add(this.postfix);
            }
        } else if (this.noSpacesAfter) {
            if (aliasNode != null) {
                TrieNode aggregateNode = new TrieNode(tokenNode, '\u0000');
                tokenNode.setBackwardLink(aggregateNode);
                aliasNode.setBackwardLink(aggregateNode);
                tokenNode = aggregateNode;
            }
        } else {
            tokenNode = tokenNode.add(" ");
            if (aliasNode != null) {
                aliasNode.appendChild(tokenNode);
            }
        }
        if (tokenNode != node) {
            tokenNode.setData(this);
            if (!this.isRequired()) {
                tokenNode.setBackwardLink(node);
            }
        }
        return tokenNode;
    }
}

