/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.completion;

import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SuggestionType;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.util.ArrayList;
import java.util.List;

public class SuggestionSequence
extends Suggestion {
    private List<Suggestion> sequence = new ArrayList<Suggestion>();

    public SuggestionSequence() {
        super(SuggestionType.SEQUENCE);
    }

    public Suggestion get(int index) {
        return this.sequence.get(index);
    }

    public int size() {
        return this.sequence.size();
    }

    public SuggestionSequence add(Suggestion suggestion) {
        if (suggestion != null) {
            if (suggestion.isSequence()) {
                for (int i = 0; i < suggestion.asSequence().size(); ++i) {
                    this.sequence.add(suggestion.asSequence().get(i));
                }
            } else {
                this.sequence.add(suggestion);
            }
        }
        return this;
    }

    @Override
    public String getToken() {
        return this.getTokenInternal(false, false);
    }

    @Override
    public void setToken(String token) {
    }

    @Override
    public String getTokenFromOffset() {
        return this.getTokenInternal(true, false);
    }

    @Override
    public String getTokenBeforeOffset() {
        return this.getTokenInternal(false, true);
    }

    private String getTokenInternal(boolean fromOffset, boolean beforeOffset) {
        StringBuilder builder = null;
        for (Suggestion suggestion : this.sequence) {
            String token;
            String string = fromOffset ? suggestion.getTokenFromOffset() : (token = beforeOffset ? suggestion.getTokenBeforeOffset() : suggestion.getToken());
            if (token == null) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(token);
            if (suggestion.getType() == SuggestionType.TOKEN) continue;
            break;
        }
        return builder != null ? builder.toString() : null;
    }

    @Override
    public int getOffset() {
        return this.sequence.size() > 0 ? this.sequence.get(0).getOffset() : 0;
    }

    public SuggestionSequence prependPrefix(String prefix) {
        if (prefix != null && prefix.length() > 0) {
            this.sequence.add(0, new TokenSuggestion(prefix).setOffset(prefix.length()));
        }
        return this;
    }

    public Suggestion prepend(Suggestion suggestion) {
        if (suggestion != null) {
            this.sequence.add(0, suggestion);
        }
        return this;
    }

    @Override
    public Suggestion compress() {
        if (this.sequence.size() == 0) {
            return null;
        }
        if (this.sequence.size() == 1) {
            return this.sequence.get(0);
        }
        for (int i = 0; i < this.sequence.size(); ++i) {
            int j;
            Suggestion suggestion = this.sequence.get(i);
            if ((suggestion = suggestion.compress()) == null) {
                this.sequence.remove(i--);
                continue;
            }
            if (suggestion.getType() != SuggestionType.TOKEN) continue;
            Object newToken = suggestion.getToken();
            int newOffset = suggestion.getOffset();
            SuggestionGroup newGroup = suggestion.getGroup();
            for (j = i + 1; j < this.sequence.size(); ++j) {
                Suggestion suggestionJ = this.sequence.get(j);
                if (suggestionJ == null) {
                    this.sequence.remove(j);
                    --j;
                }
                if (suggestionJ.getType() != SuggestionType.TOKEN) break;
                newToken = (String)newToken + suggestionJ.getToken();
                newOffset += suggestionJ.getOffset();
                newGroup = newGroup == null ? suggestionJ.getGroup() : newGroup;
            }
            if (j <= i + 1) continue;
            this.sequence.set(i, new TokenSuggestion((String)newToken, newGroup).setOffset(newOffset));
            while (j > i + 1) {
                this.sequence.remove(--j);
            }
        }
        if (this.sequence.size() == 1) {
            return this.sequence.get(0);
        }
        return this;
    }

    @Override
    public void getDisplayString(StringBuilder builder) {
        for (Suggestion suggestion : this.sequence) {
            suggestion.getDisplayString(builder);
        }
    }

    @Override
    public void getDisplayStringFromOffset(StringBuilder builder) {
        for (Suggestion suggestion : this.sequence) {
            suggestion.getDisplayStringFromOffset(builder);
        }
    }
}

