/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.completion;

import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SuggestionSequence;
import com.streamscape.slex.lang.completion.SuggestionType;
import java.util.List;

public abstract class Suggestion
implements Comparable<Suggestion> {
    private SuggestionType type;
    private SuggestionGroup group;
    private String groupName;
    private String description;
    private List<String> samples;

    public Suggestion(SuggestionType type) {
        this(type, null);
    }

    public Suggestion(SuggestionType type, SuggestionGroup group) {
        this.type = type;
        this.setGroup(group);
    }

    public SuggestionType getType() {
        return this.type;
    }

    public Suggestion setGroup(SuggestionGroup group) {
        this.group = group;
        this.groupName = group != null ? group.getGroupName() : null;
        return this;
    }

    public SuggestionGroup getGroup() {
        return this.group;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isSequence() {
        return this.type == SuggestionType.SEQUENCE;
    }

    public SuggestionSequence asSequence() {
        if (this.isSequence()) {
            return (SuggestionSequence)this;
        }
        return new SuggestionSequence().add(this);
    }

    public Suggestion compress() {
        return this;
    }

    public abstract String getToken();

    public abstract void setToken(String var1);

    public abstract String getTokenFromOffset();

    public abstract String getTokenBeforeOffset();

    public abstract int getOffset();

    public abstract void getDisplayString(StringBuilder var1);

    public abstract void getDisplayStringFromOffset(StringBuilder var1);

    public String getDisplayString() {
        StringBuilder builder = new StringBuilder();
        this.getDisplayString(builder);
        return builder.toString();
    }

    public String getDisplayStringFromOffset() {
        StringBuilder builder = new StringBuilder();
        this.getDisplayStringFromOffset(builder);
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public Suggestion trim() {
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Suggestion setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getSamples() {
        return this.samples;
    }

    public Suggestion setSamples(List<String> samples) {
        this.samples = samples;
        return this;
    }

    @Override
    public int compareTo(Suggestion other) {
        return 0;
    }
}

