/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.completion;

import com.streamscape.slex.lang.completion.AbstractSuggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SuggestionType;
import java.util.ArrayList;
import java.util.List;

public class MethodSuggestion
extends AbstractSuggestion {
    private String returnType;
    private List<MethodArgument> arguments;
    private boolean completeNameOnly;

    public MethodSuggestion(String methodName, String returnType) {
        this(methodName, returnType, null);
    }

    public MethodSuggestion(String methodName, String returnType, SuggestionGroup group) {
        super(SuggestionType.METHOD, methodName, group);
        this.returnType = returnType;
        this.completeNameOnly = false;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<MethodArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<MethodArgument> arguments) {
        this.arguments = arguments;
    }

    public void addArgument(MethodArgument argument) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<MethodArgument>();
        }
        this.arguments.add(argument);
    }

    @Override
    protected void onPrintTail(StringBuilder builder, int offset) {
        if (offset == 0 || !this.completeNameOnly) {
            builder.append("(");
            if (this.arguments != null && this.arguments.size() > 0) {
                boolean first = true;
                for (MethodArgument argument : this.arguments) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append(argument.toString());
                    first = false;
                }
            }
            builder.append(") : ").append(this.getReturnType());
        }
    }

    public static class MethodArgument {
        private String name;
        private boolean isOptional = false;
        private boolean isRepeatable = false;
        private String[] types;
        private String description;

        public MethodArgument(String name, String[] types) {
            this.name = name;
            this.types = types;
        }

        public MethodArgument setOptional(boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public void setRepeatable(boolean isRepeatable) {
            this.isRepeatable = isRepeatable;
        }

        public boolean isRepeatable() {
            return this.isRepeatable;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String[] getTypes() {
            return this.types;
        }

        public void toString(StringBuilder builder) {
            if (this.isOptional()) {
                builder.append("[");
            }
            if (this.types.length > 1) {
                builder.append("{");
            }
            for (String type : this.types) {
                builder.append(type).append(" | ");
            }
            if (this.types.length > 0) {
                builder.setLength(builder.length() - 3);
            }
            if (this.types.length > 1) {
                builder.append("}");
            }
            if (this.isRepeatable()) {
                builder.append("...");
            }
            if (this.name != null) {
                builder.append(" ").append(this.name);
            }
            if (this.isOptional()) {
                builder.append("]");
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(builder);
            return builder.toString();
        }
    }
}

