/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.completion;

import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionType;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.lexer.BufferUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DSLCompletion {
    private Suggestion completion;
    private List<Suggestion> suggestions = new ArrayList<Suggestion>();
    private Exception exception;

    public DSLCompletion() {
    }

    public DSLCompletion(Exception exception) {
        this.exception = exception;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Suggestion getCompletion() {
        return this.completion;
    }

    public DSLCompletion setCompletion(Suggestion completion) {
        this.completion = completion;
        return this;
    }

    public List<Suggestion> getSuggestions() {
        return this.suggestions;
    }

    public DSLCompletion setSuggestions(List<Suggestion> suggestions) {
        this.suggestions = suggestions;
        return this;
    }

    public DSLCompletion addSuggestion(Suggestion suggestion) {
        if (suggestion != null) {
            this.suggestions.add(suggestion);
        }
        return this;
    }

    public DSLCompletion addSuggestions(List<Suggestion> suggestions) {
        if (suggestions != null) {
            this.suggestions.addAll(suggestions);
        }
        return this;
    }

    public void order(Map<String, Integer> orderedValues) {
        if (this.suggestions != null) {
            TreeMap<Integer, Suggestion> result = new TreeMap<Integer, Suggestion>();
            for (Suggestion suggestion : this.suggestions) {
                String token = suggestion.getDisplayString();
                Integer index = orderedValues.get(token);
                if (index == null) {
                    index = Integer.MAX_VALUE;
                }
                result.put(index, suggestion);
            }
            this.suggestions = new ArrayList(result.values());
        }
    }

    public void checkAndCompress() {
        this.compress();
        if (this.suggestions == null) {
            return;
        }
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        for (Suggestion suggestion : this.suggestions) {
            strings.add((CallSite)((Object)(suggestion.getDisplayString() + "_$" + String.valueOf((Object)suggestion.getType()) + "$_$" + suggestion.getGroupName() + "$")));
        }
        block1: for (int i = strings.size() - 1; i >= 0; --i) {
            for (int duplicateIndex = 0; duplicateIndex < i; ++duplicateIndex) {
                if (!((String)strings.get(i)).equals(strings.get(duplicateIndex))) continue;
                this.suggestions.remove(i);
                continue block1;
            }
        }
    }

    public void moveSingleSuggestionToCompletion() {
        if (this.suggestions.size() == 1 && (this.completion == null || this.completion.asSequence().size() == this.suggestions.get(0).asSequence().size())) {
            this.completion = this.suggestions.get(0);
            this.suggestions.clear();
        }
    }

    private void compress() {
        if (this.completion != null) {
            this.completion = this.completion.compress();
        }
        if (this.completion != null && this.completion.getType() == SuggestionType.TOKEN && (this.completion.getTokenFromOffset() == null || this.completion.getTokenFromOffset().length() == 0)) {
            this.completion = null;
        }
        if (this.suggestions == null) {
            return;
        }
        for (int i = 0; i < this.suggestions.size(); ++i) {
            Suggestion s = this.suggestions.get(i).compress();
            if (s == null) {
                this.suggestions.remove(i);
                --i;
                continue;
            }
            this.suggestions.set(i, s);
        }
    }

    public static DSLCompletion buildPrefixAndCompletion(String prefix, List<String> completions) {
        if (completions == null || completions.size() == 0) {
            return null;
        }
        DSLCompletion result = new DSLCompletion();
        String commonPrefix = BufferUtils.getCommonPrefix(completions);
        if (commonPrefix != null) {
            result.setCompletion(new TokenSuggestion(commonPrefix).setOffset(prefix));
        } else if (prefix != null) {
            result.setCompletion(new TokenSuggestion(commonPrefix).setOffset(prefix));
        }
        result.checkAndCompress();
        return result;
    }

    public static DSLCompletion buildPrefixAndCompletion(String prefix, String ... completions) {
        return DSLCompletion.buildPrefixAndCompletion(prefix, Arrays.asList(completions));
    }

    public DSLCompletion sort() {
        Collections.sort(this.suggestions);
        return this;
    }

    public void toString(StringBuilder builder) {
        if (this.completion != null) {
            builder.append(" ->");
            this.completion.getDisplayString(builder);
            builder.append("\n");
        }
        for (Suggestion suggestion : this.suggestions) {
            builder.append("  -->");
            suggestion.getDisplayString(builder);
            builder.append("\n");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }
}

