/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.completion;

import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SuggestionType;

public abstract class AbstractSuggestion
extends Suggestion {
    private int offset;
    private String token;

    public AbstractSuggestion(SuggestionType type, String token, SuggestionGroup group) {
        super(type, group);
        this.token = token;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getTokenFromOffset() {
        return this.getTokenFromOffset(this.offset);
    }

    @Override
    public String getTokenBeforeOffset() {
        return this.getTokenBeforeOffset(this.offset);
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public Suggestion setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public Suggestion setOffset(String prefix) {
        int n = this.offset = prefix != null ? prefix.length() : 0;
        if (this.token != null && this.offset > this.token.length()) {
            this.offset = this.token.length();
        }
        return this;
    }

    @Override
    public void getDisplayString(StringBuilder builder) {
        this.onPrintToken(builder, 0);
        this.onPrintTail(builder, 0);
    }

    @Override
    public void getDisplayStringFromOffset(StringBuilder builder) {
        this.onPrintToken(builder, this.offset);
        this.onPrintTail(builder, this.offset);
    }

    protected void onPrintToken(StringBuilder builder, int offset) {
        String t = this.getTokenFromOffset(offset);
        if (t != null) {
            builder.append(t);
        }
    }

    protected abstract void onPrintTail(StringBuilder var1, int var2);

    protected String getTokenFromOffset(int offset) {
        return this.token != null ? (offset < this.token.length() ? this.token.substring(offset) : "") : null;
    }

    protected String getTokenBeforeOffset(int offset) {
        return this.token != null ? (offset > 0 && offset < this.token.length() ? this.token.substring(0, offset) : "") : null;
    }

    @Override
    public Suggestion trim() {
        if (this.token != null) {
            this.token = this.token.trim();
        }
        return this;
    }

    @Override
    public int compareTo(Suggestion other) {
        if (other instanceof AbstractSuggestion) {
            AbstractSuggestion otherSuggestion = (AbstractSuggestion)other;
            return this.token != null && otherSuggestion.token != null ? this.token.compareTo(otherSuggestion.token) : 0;
        }
        return 0;
    }
}

