/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.slex.lang.modifier.SyntaxModifier;

public class SyntaxHint {
    public static final String NEW_LINE_SYMBOL = "\n";
    public static final String DEFAULT_INDENT = "";
    public static final String DEFAULT_MODIFIER_INDENT = "   ";
    public static final boolean DEFAULT_MODIFIER_NEW_LINE = true;
    public static final SyntaxHint SPACE = new SyntaxHint(" ", false);
    protected String indent = "";
    protected boolean newLine = false;

    public SyntaxHint(String indent, boolean newLine) {
        this.indent = indent;
        this.newLine = newLine;
    }

    public String getIndent() {
        return this.indent;
    }

    public boolean isNewLine() {
        return this.newLine;
    }

    public static boolean appendSyntaxHint(StringBuilder syntax, SyntaxModifier<?> token) {
        String hint = SyntaxHint.getSyntaxHintForToken(token);
        if (hint != null) {
            syntax.append(hint);
        }
        return hint != null;
    }

    public static String getSyntaxHintForToken(SyntaxModifier<?> token) {
        if (token.getSyntaxHint() == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (token.getSyntaxHint().isNewLine()) {
            builder.append(NEW_LINE_SYMBOL);
        }
        builder.append(token.getSyntaxHint().getIndent());
        return builder.toString();
    }
}

