/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.tools.lexer.BufferUtils;

public class ScriptParser {
    protected int position = 0;
    protected String script = null;
    public static final String DELIMITERS = " \t\n\r[]()|{}=";

    public ScriptParser(String script) {
        this.script = script;
    }

    public String nextToken() {
        return this.nextToken(DELIMITERS);
    }

    public String nextToken(char delimiter) {
        return this.nextToken(Character.toString(delimiter));
    }

    public String nextTokenExcludeDelimiters(String excludedDelimiters) {
        if (excludedDelimiters != null) {
            StringBuilder builder = new StringBuilder();
            for (char c : DELIMITERS.toCharArray()) {
                if (excludedDelimiters.indexOf(c) != -1) continue;
                builder.append(c);
            }
            return this.nextToken(builder.toString(), excludedDelimiters);
        }
        return this.nextToken();
    }

    public String nextToken(String delimiters) {
        return this.nextToken(delimiters, "");
    }

    public String nextToken(String delimiters, String excludedDelimiters) {
        this.skipSpacesAndComments();
        if (this.isAtEnd()) {
            return null;
        }
        String token = null;
        int startPos = this.position;
        boolean stringtoken = false;
        if (this.script.charAt(this.position) == '\"' || this.script.charAt(this.position) == '\'') {
            if (this.script.charAt(this.position) == '\"') {
                delimiters = "\"";
            } else if (this.script.charAt(this.position) == '\'') {
                delimiters = "'";
            }
            ++this.position;
            stringtoken = true;
        }
        while (this.position < this.script.length()) {
            char c = this.script.charAt(this.position);
            if (delimiters.indexOf(c) != -1 && (c != '\'' && c != '\"' || !this.isEscapedQuote())) {
                if (!stringtoken) break;
                ++this.position;
                break;
            }
            if (c == '@' && excludedDelimiters.indexOf(c) == -1) {
                if (startPos != this.position) break;
                ++this.position;
                break;
            }
            ++this.position;
        }
        if (startPos != this.position) {
            token = this.position >= this.script.length() ? this.script.substring(startPos) : (!stringtoken && this.position - startPos > 0 ? this.script.substring(startPos, this.position) : this.script.substring(startPos, this.position));
            token = token.trim();
        }
        return token;
    }

    public String nextTokenWithEnd(char endCharacter) {
        return this.nextTokenWithEnd(endCharacter, false);
    }

    public String nextTokenWithEnd(char endCharacter, boolean ignoreQuotes) {
        this.skipSpacesAndComments();
        if (this.isAtEnd()) {
            return null;
        }
        int startPosition = this.position;
        if (this.script.charAt(this.position) == endCharacter) {
            ++this.position;
            return "";
        }
        int insideDelimiter = 0;
        int openCount = 0;
        while (this.position < this.script.length()) {
            char c = this.script.charAt(this.position);
            if (c == '\'' && !this.isEscapedQuote() && endCharacter != '\'' && !ignoreQuotes) {
                if (insideDelimiter == 0) {
                    insideDelimiter = 39;
                } else if (insideDelimiter == 39) {
                    insideDelimiter = 0;
                }
            } else if (c == '\"' && !this.isEscapedQuote() && endCharacter != '\"' && !ignoreQuotes) {
                if (insideDelimiter == 0) {
                    insideDelimiter = 34;
                } else if (insideDelimiter == 34) {
                    insideDelimiter = 0;
                }
            } else if (c == '(' && insideDelimiter == 0 && endCharacter != c) {
                ++openCount;
            } else if (c == ')' && insideDelimiter == 0 && endCharacter != c) {
                --openCount;
            } else if (c == endCharacter && insideDelimiter == 0 && openCount == 0) break;
            ++this.position;
        }
        String token = this.script.substring(startPosition, this.position);
        ++this.position;
        return token;
    }

    public String nextTokenIn(char openCharacter, char closeCharacter) {
        return this.nextTokenIn(openCharacter, closeCharacter, false, false);
    }

    public String nextTokenIn(char openCharacter, char closeCharacter, boolean ignoreQuotes, boolean skipOneLineComments) {
        this.skipSpacesAndComments();
        if (this.isAtEnd()) {
            return null;
        }
        String token = null;
        int startPosition = this.position;
        if (openCharacter != '\u0000' && this.script.charAt(this.position) != openCharacter) {
            return null;
        }
        if (openCharacter != '\u0000') {
            ++this.position;
        }
        int openCount = 0;
        while (this.position < this.script.length()) {
            this.skipComments(skipOneLineComments);
            if (this.position >= this.script.length()) break;
            char c = this.script.charAt(this.position);
            if ((c == '\'' && closeCharacter != '\'' || c == '\"' && closeCharacter != '\"') && !this.isEscapedQuote() && !ignoreQuotes && openCharacter != '\u0000') {
                do {
                    this.position = this.script.indexOf(c, this.position + 1);
                } while (this.position != -1 && this.isEscapedQuote());
                if (this.position == -1) {
                    this.position = this.script.length();
                }
            } else if (c == openCharacter && openCharacter != closeCharacter && openCharacter != '\u0000') {
                ++openCount;
            } else if (c == closeCharacter && openCharacter != closeCharacter && openCharacter != '\u0000') {
                if (openCount == 0) break;
                --openCount;
            } else if (c == closeCharacter && !this.isEscapedQuote()) break;
            ++this.position;
        }
        if ((openCount == 0 || openCount != 0 && closeCharacter != ')') && this.position < this.script.length()) {
            token = startPosition == this.position - 1 ? "" : (openCharacter == '\u0000' ? this.script.substring(startPosition, this.position) : this.script.substring(startPosition + 1, this.position));
            ++this.position;
        } else {
            this.position = startPosition;
        }
        if (token != null) {
            if (closeCharacter == '\'') {
                token = token.replace("\\'", "'");
            }
            if (closeCharacter == '\"') {
                token = token.replace("\\\"", "\"");
            }
            if (ignoreQuotes) {
                token = token.replace("\\'", "'");
                token = token.replace("\\\"", "\"");
            }
        }
        return token;
    }

    public String nextBlockIn(String opener, String closer) {
        this.skipSpacesAndComments();
        if (this.isAtEnd()) {
            return null;
        }
        String block = this.next(opener.length());
        if (block == null || !block.equals(opener)) {
            return null;
        }
        int closerIndex = this.script.indexOf(closer, this.position);
        if (closerIndex == -1) {
            return null;
        }
        block = this.script.substring(this.position, closerIndex);
        this.position = closerIndex + closer.length();
        return block;
    }

    private boolean isEscapedQuote() {
        char c = this.script.charAt(this.position);
        char cp = this.position > 0 ? this.script.charAt(this.position - 1) : (char)'\u0000';
        return (c == '\'' || c == '\"') && cp == '\\';
    }

    public static String escapeQuotes(String str) {
        return str.replace("\\", "\\\\").replace("'", "\\'").replace("\"", "\\\"");
    }

    public String next(int count) {
        this.skipSpacesAndComments();
        if (this.isAtEnd()) {
            return null;
        }
        if (this.position + count > this.script.length()) {
            return null;
        }
        this.position += count;
        return this.script.substring(this.position - count, this.position);
    }

    public boolean skipSpaces() {
        if (this.script == null) {
            throw new IllegalStateException("Script is NULL.");
        }
        int oldPosition = this.position;
        this.position = BufferUtils.skipSpaces(this.script, this.position);
        return oldPosition != this.position;
    }

    public void skipSpaces(String spaces) {
        if (this.script == null) {
            throw new IllegalStateException("Script is NULL.");
        }
        while (this.position < this.script.length() && spaces.indexOf(this.script.charAt(this.position)) != -1) {
            ++this.position;
        }
    }

    public void skipSpacesAndComments() {
        this.skipComments(false);
    }

    public void skipComments(boolean withOneLineComments) {
        int oldPosition;
        do {
            oldPosition = this.position;
            this.skipSpaces();
            if (withOneLineComments) {
                this.position = BufferUtils.skipOneLineComments(this.script, this.position);
            }
            this.position = BufferUtils.skipMultilineComments(this.script, this.position);
        } while (oldPosition != this.position);
    }

    public boolean seekTo(String str) {
        int temp = this.script.indexOf(str, this.position);
        if (temp != -1) {
            this.position = temp;
        }
        return temp != -1;
    }

    public void seek(int position) {
        this.position = position;
    }

    public boolean seekAfter(String str) {
        int temp = this.script.indexOf(str, this.position);
        if (temp != -1) {
            this.position = temp + str.length();
        }
        return temp != -1;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.script.length();
    }

    public String getBlock(int begin, int end) {
        return this.script.substring(begin, end);
    }

    public String getProcessedScript() {
        return this.script.substring(0, this.position);
    }

    public String getRemainingScript() {
        return this.script.substring(this.position, this.script.length());
    }

    public boolean isAtEnd() {
        return this.position >= this.script.length();
    }

    public boolean isPreviousSpace() {
        if (this.position <= 0 || this.script.length() == 0) {
            return false;
        }
        return BufferUtils.isSpace(this.script.charAt(this.position <= this.script.length() ? this.position - 1 : this.script.length() - 1));
    }

    public boolean endsWith(String str) {
        return this.script.endsWith(str);
    }
}

