/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PrefixTree<T> {
    private Node<T> top;
    private boolean caseSensitive = false;
    private boolean ignoreMultilineComments = true;
    private boolean ignoreOneLineComments = true;
    private boolean trimDefinitions = true;

    public PrefixTree() {
        this.caseSensitive = false;
    }

    public PrefixTree(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setIgnoreMultilineComments(boolean ignoreMultilineComments) {
        this.ignoreMultilineComments = ignoreMultilineComments;
    }

    public void setIgnoreOneLineComments(boolean ignoreOneLineComments) {
        this.ignoreOneLineComments = ignoreOneLineComments;
    }

    public void setTrimDefinitions(boolean trimDefinitions) {
        this.trimDefinitions = trimDefinitions;
    }

    public void build(Map<String, T> definitions) {
        this.top = new Node();
        for (Map.Entry<String, T> entry : definitions.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Node<T> lookupNode(String definition) {
        return this.lookupNode(this.top, definition, false);
    }

    public Node<T> lookupMoreSuitableNode(String operation) {
        return this.lookupNode(this.top, operation, true);
    }

    public Node<T> lookupDataNode(String definition) {
        Node<T> node = this.lookupNode(this.top, definition, false);
        if (node == null || !node.isDataNode()) {
            return null;
        }
        return node;
    }

    public Node<T> lookupMoreSuitableDataNode(String operation) {
        Node<T> node;
        for (node = this.lookupNode(this.top, operation, true); node != null && !node.isDataNode(); node = node.getParent()) {
        }
        if (node != null) {
            if ((operation = BufferUtils.normalizeCommandWithLowerCase(BufferUtils.removeComments(operation)).trim()).equals(node.getDefinition().toLowerCase())) {
                return node;
            }
            if (!operation.startsWith(node.getDefinition().toLowerCase())) {
                return null;
            }
            if (!(node.getData() instanceof AbstractDSLOperation && ((AbstractDSLOperation)node.getData()).getDSLSyntax().getAction().isNoSpacesAfter() || operation.startsWith(node.getDefinition().toLowerCase() + " "))) {
                return null;
            }
        }
        return node;
    }

    public void accept(Visitor<T> visitor) {
        if (this.top != null) {
            this.top.accept(visitor);
        }
    }

    public List<Node<T>> getLeafs() {
        return this.top.getLeafs();
    }

    public List<Node<T>> getDataNodes() {
        return this.top.getDataNodes();
    }

    private static boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    protected Node<T> lookupNode(Node<T> node, String definition, boolean moreSuitable) {
        if (node == null) {
            return null;
        }
        int position = 0;
        boolean wasSpace = true;
        while (position < definition.length()) {
            Node<T> lastSuitableNode;
            int oldPosition = position;
            position = BufferUtils.skipSpaces(definition, position);
            if (this.ignoreMultilineComments) {
                position = BufferUtils.skipMultilineComments(definition, position);
            }
            if (this.ignoreOneLineComments && (position == 0 || definition.charAt(position - 1) != ':')) {
                position = BufferUtils.skipOneLineComments(definition, position);
            }
            char c = ' ';
            if (oldPosition != position) {
                if (wasSpace) continue;
                wasSpace = true;
            } else {
                wasSpace = false;
                c = definition.charAt(position);
                ++position;
            }
            if ((node = (lastSuitableNode = node).lookupChild(c, this.caseSensitive)) != null) continue;
            if (moreSuitable) {
                return lastSuitableNode;
            }
            return null;
        }
        return node;
    }

    public Node<T> add(String definition, T data) {
        if (this.top == null) {
            this.top = new Node();
        }
        return this.addToNode(this.top, definition, data);
    }

    public void addAll(Collection<String> definitions, T data) {
        for (String d : definitions) {
            this.add(d, data);
        }
    }

    protected Node<T> addToNode(Node<T> node, String definition, T data) {
        boolean space = false;
        StringBuilder builder = new StringBuilder(definition);
        while (builder.length() > 0 && PrefixTree.isSpace(builder.charAt(0))) {
            builder.delete(0, 1);
        }
        if (this.trimDefinitions) {
            while (builder.length() > 0 && PrefixTree.isSpace(builder.charAt(builder.length() - 1))) {
                builder.delete(builder.length() - 1, builder.length());
            }
        }
        definition = builder.toString();
        for (char c : definition.toCharArray()) {
            if (PrefixTree.isSpace(c)) {
                c = ' ';
                if (space) continue;
                space = true;
            } else {
                space = false;
            }
            Node<T> child = node.lookupChild(c, this.caseSensitive);
            node = child == null ? node.createChild(c) : child;
        }
        node.setData(data);
        return node;
    }

    public static class Node<T> {
        private Node<T> parent;
        private Character character;
        private Map<Character, Node<T>> childs = null;
        private T data = null;

        public Node() {
            this(null, null);
        }

        public Node(Node<T> parent, Character c) {
            this.parent = parent;
            this.character = c;
            this.childs = null;
            this.data = null;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public void setData(T data) {
            this.data = data;
        }

        public T getData() {
            return this.data;
        }

        public boolean isLeaf() {
            return this.childs == null || this.childs.size() == 0;
        }

        public boolean isDataNode() {
            return this.data != null;
        }

        public void accept(Visitor<T> visitor) {
            if (this.childs != null) {
                for (Map.Entry<Character, Node<T>> entry : this.childs.entrySet()) {
                    entry.getValue().accept(visitor);
                }
            }
            visitor.visit(this);
        }

        public List<Node<T>> getLeafs() {
            ArrayList<Node<T>> leafs = new ArrayList<Node<T>>();
            this.getLeafs(leafs);
            return leafs;
        }

        public List<Node<T>> getDataNodes() {
            ArrayList<Node<T>> dataNodes = new ArrayList<Node<T>>();
            this.getDataNodes(dataNodes);
            return dataNodes;
        }

        public Node<T> getCompletion() {
            if (this.childs == null || this.childs.size() != 1 || this.isDataNode()) {
                return this;
            }
            return this.childs.entrySet().iterator().next().getValue().getCompletion();
        }

        public String getDefinition() {
            StringBuilder builder = new StringBuilder();
            this.print(builder);
            return builder.reverse().toString();
        }

        public String getDefinitionUpTo(Node<T> node) {
            StringBuilder builder = new StringBuilder();
            this.print(builder, node);
            return builder.reverse().toString();
        }

        public Character getCharacter() {
            return this.character;
        }

        public void print(StringBuilder builder) {
            if (this.character != null) {
                builder.append(this.character);
            }
            if (this.parent != null) {
                this.parent.print(builder);
            }
        }

        public void print(StringBuilder builder, Node<T> node) {
            if (this == node) {
                return;
            }
            if (this.character != null) {
                builder.append(this.character);
            }
            if (this.parent != null) {
                this.parent.print(builder, node);
            }
        }

        protected Node<T> createChild(char c) {
            if (this.childs == null) {
                this.childs = new TreeMap<Character, Node<T>>();
            }
            Node<T> child = new Node<T>(this, Character.valueOf(c));
            this.childs.put(Character.valueOf(c), child);
            return child;
        }

        public Map<Character, Node<T>> getChilds() {
            return this.childs;
        }

        public Node<T> lookupChild(char c, boolean caseSensitive) {
            if (this.childs == null) {
                return null;
            }
            if (caseSensitive) {
                return this.childs.get(Character.valueOf(c));
            }
            char cc = Character.toLowerCase(c);
            for (Map.Entry<Character, Node<T>> entry : this.childs.entrySet()) {
                if (Character.toLowerCase(entry.getKey().charValue()) != cc) continue;
                return entry.getValue();
            }
            return null;
        }

        protected void getLeafs(List<Node<T>> leafs) {
            if (this.childs != null) {
                for (Map.Entry<Character, Node<T>> entry : this.childs.entrySet()) {
                    entry.getValue().getLeafs(leafs);
                }
            }
            if (this.isLeaf()) {
                leafs.add(this);
            }
        }

        protected void getDataNodes(List<Node<T>> dataNodes) {
            if (this.childs != null) {
                for (Map.Entry<Character, Node<T>> entry : this.childs.entrySet()) {
                    entry.getValue().getDataNodes(dataNodes);
                }
            }
            if (this.isDataNode()) {
                dataNodes.add(this);
            }
        }

        public String toString() {
            return this.getDefinition();
        }
    }

    public static interface Visitor<T> {
        public void visit(Node<T> var1);
    }

    public static abstract class LeafsVisitor<T>
    implements Visitor<T> {
        @Override
        public void visit(Node<T> node) {
            if (node.isLeaf()) {
                this.onLeaf(node);
            }
        }

        public abstract void onLeaf(Node<T> var1);
    }

    public static abstract class DataNodesVisitor<T>
    implements Visitor<T> {
        @Override
        public void visit(Node<T> node) {
            if (node.isDataNode()) {
                this.onDataNode(node);
            }
        }

        public abstract void onDataNode(Node<T> var1);
    }
}

