/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import java.sql.SQLException;
import java.util.Set;
import java.util.TreeSet;

public abstract class ListSearchTagsOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    protected static final String NAME = "list search tags";

    public ListSearchTagsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST SEARCH TAGS");
        this.syntax.setDescription("Shows all search tags in the current context.\n");
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public boolean isVisible(MFSession session) {
        return true;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    protected SLResponse internalInvoke(SLStatement definition, MFSession session) throws Exception {
        RowSet result = new RowSet(ListSearchTagsOperation.createResultDescriptor());
        for (String tag : this.provider.listTags(session)) {
            result.addToRowSet(new String[]{tag});
        }
        return new SLResponse(result);
    }

    protected static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListSearchTagsOperation.addColumn(result, "Tags");
        return result;
    }

    protected SLResponse mergeResponses(SLResponse resp1, SLResponse resp2) {
        TreeSet<String> set = new TreeSet<String>();
        this.addColumnsToSet(set, resp1);
        this.addColumnsToSet(set, resp2);
        RowSet result = new RowSet(ListSearchTagsOperation.createResultDescriptor());
        for (String s : set) {
            try {
                result.addToRowSet(new String[]{s});
            }
            catch (SQLException sQLException) {}
        }
        return new SLResponse(result);
    }

    protected void addColumnsToSet(Set<String> set, SLResponse response) {
        if (response != null && response.getRowSet() != null) {
            RowSet rowSet = response.getRowSet();
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(ListSearchTagsOperation.NAME);
        }

        public String getScript() {
            return this.getName();
        }
    }
}

