/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.Trace;
import com.streamscape.ds.mf.DataspaceLexiconProcessor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.HelpOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.TextParameter;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class HelpDSLOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    protected static final String NAME = "help";
    private static final String INDENTION = "        ";

    public HelpDSLOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("HELP");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).setSyntaxHintSpace()).addModifier(new Modifier("ALL"))).addModifier(new CompoundModifier().addParameter((AbstractParameter)new TextParameter("operation").addExclusionValue("syntax")).addModifier(new Modifier("SYNTAX", false))));
        this.syntax.setAlias("?");
        this.syntax.setDescription("help                     - Shows a list of basic operations available in the current context.\nhelp all                 - Shows a list of all operations available in the current context.\nhelp <Operation>         - Shows a syntax and description of the specified operation.\nhelp <Operation> syntax  - Shows a syntax of the specified operation.\nhelp console             - Shows a list of available operations in the console.\nhelp console <Operation> - Shows a syntax and description of the specified console operation.");
        this.syntax.setSyntaxDescription("Alias ? does not applicable for console commands.");
        this.syntax.setExamples("help\nhelp all\nhelp connect\nhelp create dataspace syntax\n?\n? all\n? list nodes\nhelp console\nhelp console r:");
        this.syntax.addTag(OperationTag.session);
        this.syntax.addCompletionCommand("help all");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return true;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.existsModifier("ALL")) {
            return new Definition(true);
        }
        if (statement.existsParameter("operation")) {
            return new Definition(statement.getParameter("operation").getValue(), statement.existsModifier("SYNTAX"));
        }
        return new Definition();
    }

    protected SLResponse internalInvoke(Definition definition, MFSession session) throws Exception {
        if (definition.isHelpByOperationName()) {
            String operationName = definition.getOperationName();
            Operation operation = this.provider.getVisibleOperation(operationName, session);
            if (operation != null) {
                if (definition.isSyntaxOnly()) {
                    return HelpDSLOperation.internalInvokeHelpForOperationSyntax(operationName, operation);
                }
                return HelpDSLOperation.internalInvokeHelpForOperation(operationName, operation, session);
            }
            Set<String> operations = this.provider.listVisibleOperations(session, operationName);
            if (!operations.isEmpty()) {
                return new HelpSLResponse(null, null, operations);
            }
            return new SLResponse("Unsupported language request '" + operationName + "'.", false);
        }
        return new HelpSLResponse(null, null, this.provider.listVisibleOperations(session, null));
    }

    public static SLResponse internalInvokeHelpForOperation(String operationName, Operation<?> operation, MFSession session) {
        if (operation != null) {
            Set<String> tags;
            StringBuilder builder = new StringBuilder();
            String description = operation.getDescription(session);
            if (!StringUtils.isEmpty(description)) {
                builder.append("<b>Description:</b>\n\n");
                HelpDSLOperation.printWithIndention(builder, INDENTION, description, null);
                builder.append("\n");
            }
            String formattedDescription = builder.toString();
            builder = new StringBuilder();
            builder.append("<b>Syntax:</b>\n\n");
            HelpDSLOperation.printWithIndention(builder, INDENTION, operation.getSyntax(session), null);
            String syntaxDescription = operation.getSyntaxDescription(session);
            if (!StringUtils.isEmpty(syntaxDescription)) {
                builder.append("\n");
                HelpDSLOperation.printWithIndention(builder, INDENTION, syntaxDescription, null);
            }
            if (operation.getAlias() != null) {
                builder.append("\n<b>Alias:</b>  ").append(operation.getAlias()).append("\n");
            }
            if ((tags = operation.getTags(session)) != null && tags.size() > 0) {
                builder.append("\n<b>Tags:</b>   ");
                Iterator<String> iter = tags.iterator();
                while (iter.hasNext()) {
                    builder.append(iter.next());
                    if (!iter.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append("\n");
            }
            if (operation.getInitialVersion() != null) {
                builder.append("\n<b>Since:</b>\n\n");
                HelpDSLOperation.printWithIndention(builder, INDENTION, operation.getInitialVersion(), null);
            }
            if (operation.getStatus() != null) {
                builder.append("\n<b>Status:</b>\n\n");
                HelpDSLOperation.printWithIndention(builder, INDENTION, operation.getStatus(), null);
            }
            if (operation.getExamples(session) != null) {
                builder.append("\n");
                builder.append("<b>Examples:</b>\n\n");
                HelpDSLOperation.printWithIndention(builder, INDENTION, operation.getExamples(session), new Pair<String, String>("<i>", "</i>"));
            }
            String otherInfo = builder.toString();
            String text = formattedDescription + otherInfo;
            return HelpDSLOperation.isFromSlangTool(session) ? new HelpSLResponse(text, formattedDescription, otherInfo) : new SLResponse(text);
        }
        return new SLResponse("Unsupported language request '" + operationName + "'.", false);
    }

    public static SLResponse internalInvokeHelpForOperationSyntax(String operationName, Operation<?> operation) {
        return operation != null ? new SLResponse(operation.getSyntax(null)) : new SLResponse("Unsupported language request '" + operationName + "'.", false);
    }

    public static void printWithIndention(StringBuilder builder, String indention, String value, Pair<String, String> tag) {
        BufferedReader reader = new BufferedReader(new StringReader(value));
        if (indention == null) {
            indention = INDENTION;
        }
        try {
            String temp;
            while ((temp = reader.readLine()) != null) {
                builder.append(indention).append((String)(tag != null ? (String)tag.first + temp + (String)tag.second : temp)).append('\n');
            }
        }
        catch (Exception error) {
            Trace.logError(HelpOperation.class, error.getMessage());
        }
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        int columnCount = rowSet.getRowMetaData().getColumnCount();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String s = rowSet.getString(i);
                    if (s == null || s.length() <= 0) continue;
                    completions.add(s);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        completions.add("all");
        Collections.sort(completions);
        if (RuntimeState.isActive()) {
            completions.addAll(DataspaceLexiconProcessor.listRuntimeOperations(null, null));
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private boolean helpAll = false;
        private String operationName = null;
        private boolean syntaxOnly = false;

        public Definition() {
            super(HelpDSLOperation.NAME);
        }

        public Definition(String operationName) {
            super(HelpDSLOperation.NAME);
            this.operationName = operationName;
        }

        public Definition(String operationName, boolean syntaxOnly) {
            super(HelpDSLOperation.NAME);
            this.operationName = operationName;
            this.syntaxOnly = syntaxOnly;
        }

        public Definition(boolean helpAll) {
            super(HelpDSLOperation.NAME);
            this.helpAll = helpAll;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public boolean isHelpAll() {
            return this.helpAll;
        }

        public boolean isSyntaxOnly() {
            return this.syntaxOnly;
        }

        public boolean isHelpByOperationName() {
            return this.operationName != null;
        }

        public String getScript() {
            return "help " + (String)(this.helpAll ? "all" : (this.operationName != null ? this.operationName + (this.syntaxOnly ? " syntax" : "") : ""));
        }
    }
}

