/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class DescribeSearchTagOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    protected static final String NAME = "describe search tag";

    public DescribeSearchTagOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SEARCH TAG");
        this.syntax.setAlias("#");
        this.syntax.addActionParameter(new ExpressionParameter("tag"));
        this.syntax.addCompletionCommand("list search tags");
        this.syntax.setDescription("Shows all operations with the specified search tag that are available in the current context.\n");
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public boolean isVisible(MFSession session) {
        return true;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("tag").getValue());
    }

    protected SLResponse internalInvoke(SLStatement statement, MFSession session) throws Exception {
        RowSet result = new RowSet(DescribeSearchTagOperation.createResultDescriptor(((Definition)statement).tag));
        for (String operation : this.provider.listOperationsByTag(((Definition)statement).tag, session)) {
            result.addToRowSet(new String[]{operation});
        }
        return new SLResponse(result);
    }

    protected static RowMetaData createResultDescriptor(String tag) {
        RowMetaData result = new RowMetaData();
        DescribeSearchTagOperation.addColumn(result, "Commands with '" + tag + "' tag");
        return result;
    }

    protected SLResponse mergeResponses(SLResponse response1, SLResponse response2, String tag) {
        TreeSet<String> set = new TreeSet<String>();
        this.addColumnsToSet(set, response1);
        this.addColumnsToSet(set, response2);
        RowSet result = new RowSet(DescribeSearchTagOperation.createResultDescriptor(tag));
        for (String s : set) {
            try {
                result.addToRowSet(new String[]{s});
            }
            catch (SQLException sQLException) {}
        }
        return new SLResponse(result);
    }

    protected void addColumnsToSet(Set<String> set, SLResponse response) {
        if (response != null && response.getRowSet() != null) {
            RowSet rowSet = response.getRowSet();
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    set.add(rowSet.getString(1));
                }
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
            }
        }
    }

    @Override
    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
        RowSet rowSet = response.getRowSet();
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                completions.add(rowSet.getString(1));
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
        Collections.sort(completions);
    }

    public static class Definition
    extends AbstractSLStatement {
        String tag;

        Definition(String tag) {
            super(DescribeSearchTagOperation.NAME);
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }

        public String getScript() {
            return this.getName() + " " + this.tag;
        }
    }
}

