/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.omf.json.utils.MemoryRefStack;
import com.streamscape.slex.lang.DSLDefinitionException;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.AbstractModifierList;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.ModifierWithParameters;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.modifier.SyntaxModifier;
import com.streamscape.slex.lang.modifier.SyntaxToken;
import com.streamscape.slex.lang.parameter.SetParameter;
import java.util.List;
import java.util.Set;

public class DSLSyntaxValidator {
    public static void validate(Set<String> names, MemoryRefStack<Object> stack, List<? extends SyntaxToken<?>> elements) throws DSLDefinitionException {
        if (elements == null) {
            return;
        }
        for (SyntaxToken<?> element : elements) {
            DSLSyntaxValidator.validate(names, stack, element);
        }
    }

    public static void validate(Set<String> names, MemoryRefStack<Object> stack, SyntaxToken<?> element) throws DSLDefinitionException {
        DSLSyntaxValidator.addNameOrThrowException(names, element);
        if (stack.contains(element)) {
            return;
        }
        stack.push(element);
        if (element instanceof ModifierWithParameters) {
            DSLSyntaxValidator.validate(names, stack, ((ModifierWithParameters)element).getParameters());
        } else if (element instanceof AbstractModifierList) {
            for (AbstractModifier<?> modifier : ((AbstractModifierList)element).getModifiers()) {
                DSLSyntaxValidator.validate(names, stack, modifier);
            }
        } else if (element instanceof CompoundModifier) {
            DSLSyntaxValidator.validate(names, stack, ((CompoundModifier)element).getElements());
        } else if (element instanceof BlockModifier) {
            ((BlockModifier)element).validate(stack);
        } else if (element instanceof SetParameter) {
            ((SetParameter)element).validate(stack);
        } else if (element instanceof SetModifier) {
            ((SetModifier)element).validate(stack);
        }
        stack.pop();
    }

    public static void addNameOrThrowException(Set<String> names, SyntaxToken<?> element) throws DSLDefinitionException {
        if (!names.add(element.getName())) {
            throw new DSLDefinitionException((element instanceof SyntaxModifier ? "Modifier" : "Parameter") + " name '" + element.getName() + "' already in use.");
        }
    }
}

