/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.omf.json.utils.MemoryRefStack;
import com.streamscape.slex.lang.DSLDefinitionException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidator;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.AbstractModifierList;
import com.streamscape.slex.lang.modifier.Action;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.modifier.SyntaxModifier;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.trie.Trie;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DSLStatementSyntax
extends AbstractModifierList<DSLStatementSyntax> {
    public static final String ACTION_VERB_NAME = "ACTION_VERB";
    public static final String ACTION_PREDICATE_NAME = "ACTION_PREDICATE";
    public static final String ACTION_SUBJECT_NAME = "ACTION_SUBJECT";
    public static final String ACTION_SUBJECT_VALUE_NAME = "ACTION_SUBJECT_VALUE";
    public static final String DEFAULT_INITIAL_VERSION = "3.4 Build 1";
    public static final String DEFAULT_STATUS = "Current";
    private Action action;
    private ChoiceModifier predicate;
    private Subject subject;
    private String alias;
    private String hiddenAlias;
    private String examples;
    private Set<String> tags;
    private String initialVersion = "3.4 Build 1";
    private String status = "Current";
    private List<String> completionCommands = null;

    public DSLStatementSyntax(String name) {
        super(name);
    }

    public DSLStatementSyntax setAction(Action action) {
        this.action = action;
        return this;
    }

    public DSLStatementSyntax setAction(String token) {
        this.action = new Action(token);
        return this;
    }

    public DSLStatementSyntax addActionParameter(SyntaxParameter<?> parameter) {
        this.action.addParameter(parameter);
        return this;
    }

    public DSLStatementSyntax setPredicate(ChoiceModifier predicate) {
        this.predicate = predicate;
        return this;
    }

    public DSLStatementSyntax setSubject(Subject subject) {
        this.subject = subject;
        return this;
    }

    public Action getAction() {
        return this.action;
    }

    public ChoiceModifier getPredicate() {
        return this.predicate;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public DSLStatementSyntax validate() throws DSLDefinitionException {
        HashSet<String> names = new HashSet<String>();
        MemoryRefStack<Object> stack = new MemoryRefStack<Object>();
        if (this.action == null) {
            throw new DSLDefinitionException("Action is not defined.");
        }
        DSLSyntaxValidator.validate(names, stack, this.action);
        if (this.predicate != null) {
            DSLSyntaxValidator.validate(names, stack, this.predicate);
        }
        if (this.subject != null) {
            DSLSyntaxValidator.validate(names, stack, this.subject);
        }
        DSLSyntaxValidator.validate(names, stack, this.modifiers);
        if (!(this.alias == null || this.predicate == null || this.predicate.isRequired() && this.predicate.getModifiers().size() <= 0)) {
            throw new DSLDefinitionException("Alias cannot be defined, because there is complex predicate.");
        }
        if (this.predicate != null && this.predicate.getModifiers() != null && this.predicate.getModifiers().size() > 0) {
            for (AbstractModifier<?> modifier : this.predicate.getModifiers()) {
                if (modifier instanceof Modifier && (((Modifier)modifier).getParameters() == null || ((Modifier)modifier).getParameters().size() <= 0)) continue;
                throw new DSLDefinitionException("Predicate should contain simple modifiers without parameters only.");
            }
        }
        boolean includedToDefinition = true;
        boolean choiceModifierIncludedToDefinition = false;
        for (AbstractModifier modifier : this.modifiers) {
            if (modifier.getIncludeToDefinition()) {
                if (!includedToDefinition) {
                    throw new DSLDefinitionException("Modifier " + modifier.getName() + " cannot be included in definition.");
                }
                if (!modifier.isRequired()) {
                    throw new DSLDefinitionException("Modifier " + modifier.getName() + " cannot be included in definition because it is optional.");
                }
                if (!(modifier instanceof Modifier) && !(modifier instanceof ChoiceModifier)) {
                    throw new DSLDefinitionException("Only simple modifiers or choice modifiers can be included to statement definition.");
                }
                if (modifier instanceof ChoiceModifier) {
                    choiceModifierIncludedToDefinition = true;
                }
                if (modifier instanceof ChoiceModifier || !choiceModifierIncludedToDefinition) continue;
                throw new DSLDefinitionException("Choice modifier can be included in definition only once and should be the last modifier included to definition.");
            }
            includedToDefinition = false;
        }
        return this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder syntax = new StringBuilder();
        this.appendToSyntax(syntax, this.action, isFull);
        this.appendToSyntax(syntax, this.predicate, isFull);
        this.appendToSyntax(syntax, this.subject, isFull);
        if (this.modifiers != null) {
            syntax.append(super.onGetSyntax(isFull));
        }
        if (syntax.length() > 0 && syntax.charAt(0) == ' ') {
            syntax.delete(0, 1);
        }
        return syntax.toString();
    }

    public String getStatementDefinition() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.action.getToken());
        if (this.predicate != null) {
            builder.append(" ").append(this.predicate.getSyntax());
        }
        if (this.subject != null) {
            builder.append(" ").append(this.subject.getToken());
        }
        return BufferUtils.normalizeCommand(builder.toString().toLowerCase().trim());
    }

    public Set<String> getStatementDefinitions() {
        return this.getStatementDefinitions(false);
    }

    public Set<String> getStatementDefinitionsUpToFirstParameter() {
        return this.getStatementDefinitions(true);
    }

    private Set<String> getStatementDefinitions(boolean upToFirstParameter) {
        HashSet<String> definitions = new HashSet<String>();
        String definition = this.action.getToken();
        if (upToFirstParameter && this.action.getParameters() != null && this.action.getParameters().size() > 0) {
            definitions.add(definition.toLowerCase().trim());
        } else {
            this.appendPredicateToDefinition(definition, definitions, upToFirstParameter);
        }
        if (this.alias != null) {
            definitions.add(this.alias.toLowerCase().trim());
        }
        return definitions;
    }

    private void appendPredicateToDefinition(String definition, Set<String> definitions, boolean upToFirstParameter) {
        if (this.predicate != null) {
            if (!this.predicate.isRequired() || this.predicate.getToken().length() == 0 && this.predicate.getModifiers().size() == 0) {
                this.appendSubjectToDefinition(definition, definitions, upToFirstParameter);
            }
            for (AbstractModifier<?> modifier : this.predicate.getModifiers()) {
                Object definition1 = definition;
                if (modifier.getToken() != null && modifier.getToken().length() > 0) {
                    definition1 = (String)definition1 + " " + modifier.getToken();
                }
                this.appendSubjectToDefinition((String)definition1, definitions, upToFirstParameter);
            }
        } else {
            this.appendSubjectToDefinition(definition, definitions, upToFirstParameter);
        }
    }

    private void appendSubjectToDefinition(String definition, Set<String> definitions, boolean upToFirstParameter) {
        if (this.subject != null) {
            String definition1 = definition + " " + this.subject.getToken();
            if (upToFirstParameter && this.subject.getParameters() != null && this.subject.getParameters().size() > 0) {
                definitions.add(BufferUtils.normalizeCommand(definition1.toLowerCase().trim()));
            } else {
                this.appendModifiersToDefinition(definition1, definitions, upToFirstParameter);
            }
        } else {
            this.appendModifiersToDefinition(definition, definitions, upToFirstParameter);
        }
    }

    private void appendModifiersToDefinition(String definition, Set<String> definitions, boolean upToFirstParameter) {
        AbstractModifier modifier;
        boolean lastAdded = false;
        Iterator iterator = this.modifiers.iterator();
        while (iterator.hasNext() && (modifier = (AbstractModifier)iterator.next()).getIncludeToDefinition()) {
            if (modifier instanceof Modifier) {
                if (modifier.getToken() != null && modifier.getToken().length() > 0) {
                    definition = (String)definition + " " + modifier.getToken();
                }
                if (!upToFirstParameter || ((Modifier)modifier).getParameters() == null || ((Modifier)modifier).getParameters().size() <= 0) continue;
                break;
            }
            if (!(modifier instanceof ChoiceModifier)) continue;
            for (AbstractModifier<?> modifier1 : ((ChoiceModifier)modifier).getModifiers()) {
                Object definition1 = definition;
                if (modifier1.getToken() != null && modifier1.getToken().length() > 0) {
                    definition1 = (String)definition1 + " " + modifier1.getToken();
                }
                definitions.add(BufferUtils.normalizeCommand(((String)definition1).toLowerCase().trim()));
                lastAdded = true;
            }
        }
        if (!lastAdded) {
            definitions.add(BufferUtils.normalizeCommand(((String)definition).toLowerCase().trim()));
        }
    }

    @Override
    public DSLStatementSyntax setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public String getAlias() {
        if (this.alias != null) {
            return this.alias.toLowerCase();
        }
        return this.alias;
    }

    public String getHiddenAlias() {
        if (this.hiddenAlias != null) {
            return this.hiddenAlias.toLowerCase();
        }
        return this.hiddenAlias;
    }

    @Override
    public DSLStatementSyntax setHiddenAlias(String hiddenAlias) {
        this.hiddenAlias = hiddenAlias;
        return this;
    }

    public DSLStatementSyntax addTag(String tag) {
        if (this.tags == null) {
            this.tags = new TreeSet<String>();
        }
        this.tags.add(tag.toLowerCase().trim());
        return this;
    }

    public DSLStatementSyntax addTag(OperationTag tag) {
        return this.addTag(tag.name());
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean containsTag(String tag) {
        return this.tags != null && (tag == null || tag.equals("") || this.tags.contains(tag));
    }

    public boolean containsTag(OperationTag tag) {
        return this.containsTag(tag.name());
    }

    public DSLStatementSyntax setExamples(String examples) {
        this.examples = examples;
        return this;
    }

    public String getExamples() {
        return this.examples;
    }

    public String getInitialVersion() {
        return this.initialVersion;
    }

    public DSLStatementSyntax setInitialVersion(String initialVersion) {
        this.initialVersion = initialVersion;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public DSLStatementSyntax setStatus(String status) {
        this.status = status;
        return this;
    }

    public DSLStatement parse(String script) throws DSLDefinitionException, DSLSyntaxValidationException {
        return this.parse(script, true);
    }

    public DSLStatement parse(String script, boolean withThrow) throws DSLDefinitionException, DSLSyntaxValidationException {
        DSLStatement statement;
        block3: {
            script = this.replaceAliasInScript(script);
            statement = new DSLStatement(this.getName());
            statement.setOriginalStatement(script);
            try {
                ScriptParser parser = new ScriptParser(script);
                this.parse(statement, parser);
                parser.skipSpacesAndComments();
                if (!parser.isAtEnd()) {
                    throw new DSLSyntaxValidationException("Parsing error, unknown symbols at the end of the query: '" + parser.getRemainingScript() + "'.");
                }
            }
            catch (Exception exception) {
                if (!withThrow) break block3;
                throw exception;
            }
        }
        return statement;
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        this.parseToken(statement, parser, this.action);
        this.parseToken(statement, parser, this.predicate);
        this.parseToken(statement, parser, this.subject);
        super.parse(statement, parser);
        return statement;
    }

    protected void parseToken(StatementValueList statement, ScriptParser parser, SyntaxModifier<?> token) throws DSLSyntaxValidationException {
        if (token != null) {
            token.parse(statement, parser);
        }
    }

    protected void appendToSyntax(StringBuilder syntax, SyntaxModifier<?> token, boolean isFull) {
        if (token == null) {
            return;
        }
        if (!SyntaxHint.appendSyntaxHint(syntax, token)) {
            syntax.append(" ");
        }
        syntax.append(token.getSyntax(isFull));
    }

    private String replaceAliasInScript(String script) {
        int index;
        if (this.alias != null) {
            for (index = 0; index < script.length() && script.charAt(index) == ' '; ++index) {
            }
            if (script.toLowerCase().startsWith(this.alias.toLowerCase(), index)) {
                return this.getStatementDefinition() + script.substring(index + this.alias.length());
            }
        }
        if (this.hiddenAlias != null) {
            for (index = 0; index < script.length() && script.charAt(index) == ' '; ++index) {
            }
            if (script.toLowerCase().startsWith(this.hiddenAlias.toLowerCase(), index)) {
                return new ArrayList<String>(this.getStatementDefinitions()).get(0) + script.substring(index + this.hiddenAlias.length());
            }
        }
        return script;
    }

    public Trie buildTrie() {
        Trie trie = new Trie();
        TrieNode node = trie.getTopNode();
        if (this.action != null) {
            node = this.action.buildTrie(node);
        }
        if (this.predicate != null) {
            node = this.predicate.buildTrie(node);
        }
        if (this.subject != null) {
            node = this.subject.buildTrie(node);
        }
        node = super.buildTrie(node);
        return trie;
    }

    public void addCompletionCommand(String completionCommand) {
        if (this.completionCommands == null) {
            this.completionCommands = new ArrayList<String>();
        }
        this.completionCommands.add(completionCommand);
    }

    public List<String> getCompletionCommands() {
        return this.completionCommands;
    }

    public DSLStatementCompletion completeFirstParameter(String script) {
        if (this.completionCommands == null || this.completionCommands.size() == 0) {
            return null;
        }
        script = this.replaceAliasInScript(script);
        DSLStatement statement = new DSLStatement("Temp statement for completion");
        ScriptParser parser = new ScriptParser(script);
        try {
            if (this.action != null) {
                this.action.parseWithoutParameters(statement, parser);
            }
            if (this.predicate != null) {
                this.predicate.parse(statement, parser);
            }
            if (this.subject != null) {
                this.subject.parseWithoutParameters(statement, parser);
            }
            DSLStatementCompletion completion = new DSLStatementCompletion();
            completion.completionCommands = this.completionCommands;
            completion.scriptToComplete = parser.getRemainingScript();
            return completion;
        }
        catch (DSLSyntaxValidationException dSLSyntaxValidationException) {
            return null;
        }
    }

    public static class DSLStatementCompletion {
        public List<String> completionCommands;
        public String staticScript;
        public String scriptToComplete;
    }
}

