/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class DSLStatement
extends StatementValueList {
    private transient String originalStatement;

    DSLStatement(String name) {
        super(name);
    }

    public StatementModifierValue getAction() {
        return this.getModifier("ACTION_VERB");
    }

    public StatementModifierValue setAction(String value) {
        return this.addModifier("ACTION_VERB", value);
    }

    public StatementModifierValue getPredicate() {
        return this.getModifier("ACTION_PREDICATE");
    }

    public boolean existsPredicate() {
        return this.existsModifier("ACTION_PREDICATE");
    }

    public StatementModifierValue setPredicate(String value) {
        return this.addModifier("ACTION_PREDICATE", value);
    }

    public StatementModifierValue getSubject() {
        return this.getModifier("ACTION_SUBJECT");
    }

    public StatementModifierValue setSubject(String value) {
        return this.addModifier("ACTION_SUBJECT", value);
    }

    public String getDefinition() {
        StringBuilder builder = new StringBuilder();
        if (this.getAction().isPresent()) {
            builder.append(this.getAction().getToken());
        }
        if (this.getPredicate().isPresent()) {
            builder.append(" ").append(this.getPredicate().getToken());
        }
        if (this.getSubject().isPresent()) {
            builder.append(" ").append(this.getSubject().getToken());
        }
        return builder.toString().toLowerCase();
    }

    public void setOriginalStatement(String originalStatement) {
        this.originalStatement = originalStatement;
    }

    public String getOriginalStatement() {
        return this.originalStatement;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.print(builder);
        return builder.toString();
    }

    public RowSet toRowSetParameters() throws Exception {
        RowMetaData meta = new RowMetaData(10);
        meta.addColumn("Name");
        meta.addColumn("Value");
        RowSet rowSet = new RowSet(meta);
        for (StatementValue value : this.values) {
            String svalue = "";
            svalue = value instanceof StatementParameterValue ? ((StatementParameterValue)value).getValue() : (value instanceof StatementModifierValue ? ((StatementModifierValue)value).getToken() : value.toString());
            rowSet.addToRowSet(new Object[]{value.getName(), svalue});
        }
        return rowSet;
    }

    public String toStringParameters() throws Exception {
        RowSetPrinter rowSetPrinter = new RowSetPrinter();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        rowSetPrinter.setPrintStream(new PrintStream(os));
        rowSetPrinter.print(this.toRowSetParameters());
        return os.toString();
    }
}

