/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.mf.DataspaceMFSession;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.advisory.SystemAdvisories;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.SystemEvents;
import com.streamscape.sdo.excp.SystemExceptions;
import com.streamscape.sdo.operation.BroadcastSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.ReservedNames;
import com.streamscape.sef.dispatcher.ReservedSubjects;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.dispatcher.ServiceMFSession;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.HelpDSLOperation;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.modifier.SetModifier;
import com.streamscape.slex.lang.parameter.DataspaceVariableReferenceParameter;
import com.streamscape.slex.lang.parameter.DateParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.trie.Trie;
import com.streamscape.slex.lang.value.AbstractStatementValueList;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public abstract class AbstractDSLOperation<T extends SLCallable>
implements Operation<T> {
    protected DSLStatementSyntax syntax;
    protected T callable;
    protected DSLProvider<T> provider;
    protected boolean preserveCompletionOrder = false;
    private boolean isAdministrative;
    private boolean isDiagnostic;
    private boolean isExportable = false;
    private Set<DataspaceType> exportableDataspaceTypes;
    protected static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
    protected static final SimpleDateFormat SCHEDULER_DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss a");
    private static final Set<String> VISIBLE_SYSTEM_EVENTS = new HashSet<String>();
    private static final Object[] EXCLUDED_TYPES;
    private static final Object[] EXCLUDED_TYPES_NO_BOOLEAN;
    private static final Object[] EXCLUDED_TYPES_NUMERIC_ONLY;
    private static final String COMPACT_SYNTAX = "{ boolean | byte | short | int | long | float | double | string }";
    private static final String COMPACT_SYNTAX_NO_BOOLEAN = "{ byte | short | int | long | float | double | string }";
    private static final String COMPACT_SYNTAX_NUMERIC_ONLY = "{ byte | short | int | long | float | double }";

    protected AbstractDSLOperation() {
        this(false, false);
    }

    protected AbstractDSLOperation(boolean isAdministrative, boolean isDiagnostic) {
        this.isAdministrative = isAdministrative;
        this.isDiagnostic = isDiagnostic;
    }

    @Override
    public DSLStatementSyntax getDSLSyntax() {
        return this.syntax;
    }

    protected void createDSLSyntax(String name) {
        this.createDSLSyntax(name, false);
    }

    protected void createDSLSyntax(String name, boolean setAction) {
        this.syntax = new DSLStatementSyntax(name);
        if (setAction) {
            this.syntax.setAction(name.toUpperCase());
        }
        if (this.isAdministrative) {
            this.syntax.addTag(OperationTag.administrative);
        }
        if (this.isDiagnostic) {
            this.syntax.addTag(OperationTag.diagnostic);
        }
    }

    public T callable() {
        return this.callable;
    }

    public AbstractDSLOperation<T> setAdministrative(boolean administrative) {
        this.isAdministrative = administrative;
        this.syntax.addTag(OperationTag.administrative);
        return this;
    }

    @Override
    public boolean isVisible(MFSession session) {
        return this.isAdministrativeVisible(session) && this.isDiagnosticVisible(session) && (this.isNativeContext(session) || this.isVisibleInForeignContexts(session));
    }

    @Override
    public boolean isVisible(MFSession session, SLStatement statement) {
        return this.isVisible(session);
    }

    @Override
    public boolean isVisibleForExecution(MFSession session) {
        return this.isVisible(session);
    }

    protected boolean isAdministrativeVisible(MFSession session) {
        return !this.isAdministrative || session != null && session.getOwner() != null && session.getOwner().isAdministrator();
    }

    protected boolean isDiagnosticVisible(MFSession session) {
        return session == null || !session.isDiagnostic() || this.syntax.containsTag(OperationTag.diagnostic);
    }

    protected boolean isNativeContext(MFSession session) {
        return session == null || session.isInstant() || this.callable.isNativeContext(session);
    }

    protected boolean isVisibleInForeignContexts(MFSession session) {
        return this.isVisibleInDataspaceContext(session) || this.isVisibleInServiceContext(session);
    }

    protected boolean isVisibleInDataspaceContext(MFSession session) {
        return session instanceof DataspaceMFSession && !((DataspaceMFSession)session).isVirtualServer() && this.isExportable() && (this.exportableDataspaceTypes == null || this.exportableDataspaceTypes.contains((Object)((AbstractDataspace)session.getContext().getEntity()).getDataspaceType()));
    }

    protected boolean isVisibleInServiceContext(MFSession session) {
        return session instanceof ServiceMFSession && this.isExportable();
    }

    public AbstractDSLOperation<T> setExportable() {
        this.isExportable = true;
        return this;
    }

    public AbstractDSLOperation<T> setExportable(DataspaceType ... types) {
        this.setExportable();
        if (this.exportableDataspaceTypes == null) {
            this.exportableDataspaceTypes = new HashSet<DataspaceType>();
        }
        this.exportableDataspaceTypes.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public boolean isExportable() {
        return this.isExportable;
    }

    @Override
    public void activate(T callable) {
        this.callable = callable;
    }

    @Override
    public SLResponse invoke(DSLStatement statement, MFSession session) throws Exception {
        this.resolveDataspaceVariableReferences(session, statement);
        return SLOperationLogger.invokeWithLoggerWrap(session, () -> this.invoke(this.convertDslToSl(statement), session, -1L), false);
    }

    private void resolveDataspaceVariableReferences(MFSession session, DSLStatement statement) throws Exception {
        if (session == null) {
            return;
        }
        for (String parameterName : statement.listParameters()) {
            StatementParameterValue parameter = statement.getParameter(parameterName);
            if (!parameter.isDataspaceReference()) continue;
            Object value = DataspaceVariableReferenceParameter.getVariableValue(session, parameter.getValue());
            parameter.setValue(String.valueOf(value));
        }
    }

    public SLResponse processBroadcastResponse(String firstNode, SLResponse firstResponse, Map<String, Object> otherResponses) throws Exception {
        if (firstResponse.getRowSet() != null) {
            this.addBroadcastRowSets(firstResponse, otherResponses);
            return firstResponse;
        }
        if (this.useBroadcastResponse()) {
            BroadcastSLResponse result = new BroadcastSLResponse();
            result.setPrefix(this.getBroadcastResponsePrefix());
            this.addBroadcastValue(firstNode, firstResponse, result);
            if (otherResponses != null) {
                otherResponses.forEach((key, value) -> {
                    if (value instanceof SLResponse) {
                        this.addBroadcastValue((String)key, (SLResponse)value, result);
                    } else if (value instanceof Throwable) {
                        result.addValue((String)key, value);
                    } else {
                        result.addValue((String)key, new Exception("Response not received."));
                    }
                });
            }
            return result;
        }
        return firstResponse;
    }

    protected void addBroadcastRowSets(SLResponse firstResponse, Map<String, Object> otherResponses) throws Exception {
        if (firstResponse.getRowSet() != null && otherResponses != null) {
            for (Map.Entry<String, Object> entry : otherResponses.entrySet()) {
                if (!(entry.getValue() instanceof SLResponse)) continue;
                this.addBroadcastRowSet((SLResponse)entry.getValue(), firstResponse.getRowSet());
            }
        }
    }

    protected void addBroadcastRowSet(SLResponse response, RowSet result) throws Exception {
        result.addAll(response.getRowSet());
    }

    protected void addBroadcastValue(String nodeName, SLResponse response, BroadcastSLResponse result) {
        result.addValue(nodeName, response.isOK() ? (response.getText() != null ? response.getText() : "OK") : (response.getException() != null ? response.getException() : new Exception(response.getText())));
    }

    protected boolean useBroadcastResponse() {
        return false;
    }

    protected String getBroadcastResponsePrefix() {
        return null;
    }

    @Override
    public DSLStatement parseDsl(String script, MFSession session) throws ParsingException {
        try {
            return this.syntax.parse(script);
        }
        catch (Exception exception) {
            throw new ParsingException(this.getSyntaxErrorMessage(exception, session), this);
        }
    }

    @Override
    public DSLStatement parseDsl(String script) throws ParsingException {
        return this.parseDsl(script, null);
    }

    protected String getSyntaxErrorMessage(Exception exception, MFSession session) {
        return this.getSyntaxErrorMessage(Utils.formatExceptionWithUnrepeatedCauses(exception, "\n"), session);
    }

    public String getSyntaxErrorMessage(String errorMessage) {
        return this.getSyntaxErrorMessage(errorMessage, null);
    }

    public String getSyntaxErrorMessage(String errorMessage, MFSession session) {
        return AbstractDSLOperation.getSyntaxErrorMessage(this.getSyntax(session), errorMessage, session);
    }

    public static String getSyntaxErrorMessage(Operation<?> operation, String errorMessage) {
        return AbstractDSLOperation.getSyntaxErrorMessage(operation.getSyntax(null), errorMessage, null);
    }

    protected static String getSyntaxErrorMessage(String syntax, String errorMessage, MFSession session) {
        StringBuilder builder = new StringBuilder();
        HelpDSLOperation.printWithIndention(builder, null, errorMessage, null);
        builder.append("\n\nSyntax:\n\n");
        HelpDSLOperation.printWithIndention(builder, null, syntax, null);
        return builder.toString();
    }

    @Override
    public SLStatement parse(String script, MFSession session) throws ParsingException {
        DSLStatement dslStatement = this.parseDsl(script, session);
        try {
            this.resolveDataspaceVariableReferences(session, dslStatement);
        }
        catch (Exception exception) {
            throw new ParsingException(Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
        return this.convertDslToSl(dslStatement);
    }

    public abstract SLStatement convertDslToSl(DSLStatement var1) throws ParsingException;

    @Override
    public DSLCompletion completeDsl(String command, MFSession session, SuggestionGroup group) {
        DSLCompletion completion = this.completeFirstParameter(command, session);
        if (completion == null) {
            if (command.equalsIgnoreCase(this.getName()) && !this.syntax.isNoSpacesAfter()) {
                completion = new DSLCompletion().setCompletion(new TokenSuggestion(command + " ", group != null ? group : SuggestionGroup.OPERATION).setOffset(command.length()));
            } else if (!this.getName().equals("set") && !this.getName().equals("help")) {
                completion = this.completeSyntax(command, session);
            }
        }
        return completion;
    }

    private DSLCompletion completeFirstParameter(String command, MFSession session) {
        DSLCompletion completion;
        DSLStatementSyntax.DSLStatementCompletion comp = this.syntax.completeFirstParameter(command);
        if (comp == null || comp.completionCommands == null || comp.completionCommands.isEmpty() || comp.scriptToComplete.isEmpty() && !command.endsWith(" ")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        this.doFillCompletionsList(comp, session, completions);
        if (completions.isEmpty()) {
            return null;
        }
        PrefixTree<Object> prefixTree = new PrefixTree<Object>(true);
        Object object = new Object();
        for (String c : completions) {
            prefixTree.add(c, object);
        }
        PrefixTreeCompleter completer = new PrefixTreeCompleter(prefixTree);
        if (this.preserveCompletionOrder) {
            completer.setOrderedValues(completions);
        }
        if ((completion = completer.completeDsl(comp.scriptToComplete)) != null) {
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }

    private DSLCompletion completeSyntax(String command, MFSession session) {
        Trie trie = this.syntax.buildTrie();
        DSLCompletion completion = trie.complete(command, this.callable, session, this);
        if (completion == null) {
            try {
                this.validateDsl(command, session);
            }
            catch (Exception exception) {
                completion = new DSLCompletion(exception);
            }
        }
        return completion;
    }

    private void validateDsl(String command, MFSession session) throws FabricException {
        this.syntax.parse(command);
    }

    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        for (String completionCommand : comp.completionCommands) {
            SLResponse response = this.doGetCompletionCommandResponse(completionCommand, session);
            if (response == null || !response.isOK() || response.getException() != null) continue;
            this.doInternalParseCompletionResponse(response, completions);
        }
    }

    protected void setPreserveCompletionOrder() {
        this.preserveCompletionOrder = true;
    }

    protected SLResponse doGetCompletionCommandResponse(String completionCommand, MFSession session) {
        try {
            SLStatement statement = this.provider.parse(completionCommand, session);
            if (statement != null) {
                return this.provider.invoke(statement, session, 5000L);
            }
            Trace.logError(this, "Parsing completion command '" + completionCommand + "' failed.");
            return null;
        }
        catch (ParsingException exception) {
            Trace.logException(this, exception, true);
            return null;
        }
    }

    protected void doInternalParseCompletionResponse(SLResponse response, List<String> completions) {
    }

    public boolean isCompleted(String completion) {
        return false;
    }

    public void setProvider(DSLProvider<T> provider) {
        this.provider = provider;
    }

    @Override
    public String getName() {
        return this.syntax.getName();
    }

    @Override
    public String getAlias() {
        return this.syntax.getAlias();
    }

    @Override
    public String getHiddenAlias() {
        return this.syntax.getHiddenAlias();
    }

    @Override
    public Set<String> getTags(MFSession session) {
        return this.syntax.getTags();
    }

    @Override
    public void addTag(String tag) {
        if (!this.syntax.containsTag(tag = tag.toLowerCase().trim())) {
            this.syntax.addTag(tag);
            if (this.provider instanceof AbstractDSLProvider) {
                ((AbstractDSLProvider)this.provider).onTagAdd(tag, this);
            }
        }
    }

    @Override
    public String getDescription(MFSession session) {
        return this.syntax.getDescription();
    }

    @Override
    public String getSyntaxDescription(MFSession session) {
        return this.syntax.getSyntaxDescription();
    }

    @Override
    public String getSyntax(MFSession session) {
        return this.syntax.getSyntax();
    }

    @Override
    public String getExamples(MFSession session) {
        return this.syntax.getExamples();
    }

    @Override
    public String getInitialVersion() {
        return this.syntax.getInitialVersion();
    }

    @Override
    public String getStatus() {
        return this.syntax.getStatus();
    }

    protected static boolean isFromSlangTool(MFSession session) {
        return session != null && session.isFromSlangTool();
    }

    public static String skipNull(Object value) {
        return value == null ? "" : value.toString();
    }

    protected Operation<T> getOperation(String name) {
        return this.provider != null ? this.provider.lookupOperation(name) : null;
    }

    public static RowMetaData createResultDescriptor(String ... columnNames) {
        RowMetaData result = new RowMetaData();
        for (String columnName : columnNames) {
            AbstractDSLOperation.addColumn(result, columnName);
        }
        return result;
    }

    public static RowMetaData createSimpleResultDescriptor() {
        return AbstractDSLOperation.createResultDescriptor("Property", "Value");
    }

    public static void addColumn(RowMetaData metaData, String columnName) {
        metaData.addColumn(columnName, SQLType.STRING);
    }

    public static void addGenericColumn(RowMetaData metaData, String columnName) {
        metaData.addColumn(columnName, SQLType.OTHER);
    }

    public static void add(RowSet rowSet, Object[] values) {
        try {
            rowSet.addToRowSet(values);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addValues(RowSet rowSet, Object ... values) {
        try {
            rowSet.addToRowSet(values);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void raiseSLMessage(String message, MFSession session) {
        this.doRaiseSLMessage(new SLMessage(message, session));
    }

    protected void raiseSLMessageError(String message, MFSession session) {
        this.raiseSLMessage(message, false, session);
    }

    protected void raiseSLMessageError(Throwable exception, MFSession session) {
        this.doRaiseSLMessage(new SLMessage(exception, session));
    }

    protected void raiseSLMessageWarning(String message, MFSession session) {
        this.raiseSLMessageWarning("", message, session);
    }

    protected void raiseSLMessageWarning(String prefix, String message, MFSession session) {
        this.doRaiseSLMessage(new SLMessage(prefix + "WARNING: " + message, SLMessage.Type.WARNING, session));
    }

    protected void raiseSLMessage(String message, boolean isOK, MFSession session) {
        this.doRaiseSLMessage(new SLMessage(message, isOK, session));
    }

    protected void doRaiseSLMessage(SLMessage message) {
    }

    protected static Pattern compilePattern(String pattern) throws Exception {
        try {
            return pattern != null ? Pattern.compile(pattern) : null;
        }
        catch (Exception exception) {
            throw new FabricException(exception.getMessage());
        }
    }

    protected static Pattern compileExtendedPattern(String pattern) throws Exception {
        return pattern != null ? AbstractDSLOperation.compilePattern(pattern.replace("%", ".*")) : null;
    }

    protected static Pattern compileExtendedLikePattern(DSLStatement statement, String parameterName) throws Exception {
        String pattern = AbstractDSLOperation.getLikeParameterValue(statement);
        return pattern != null ? AbstractDSLOperation.compilePattern(pattern.replace("%", ".*")) : null;
    }

    public static String formatCreationDate(File file) {
        long result = FileIOUtils.getCreationTime(file);
        return result != -1L ? AbstractDSLOperation.formatDate(result) : "n/a";
    }

    public static String formatDate(long time) {
        return AbstractDSLOperation.formatDate(new Date(time));
    }

    public static String formatDate(Date date) {
        return date != null ? DateParameter.formatDate(date) : "n/a";
    }

    public static String formatDateMillis(long time) {
        return AbstractDSLOperation.formatDateMillis(new Date(time));
    }

    public static String formatDateMillis(Date date) {
        return DateParameter.formatDateMillis(date);
    }

    public static boolean isAll(boolean isAll, MFSession session) {
        return isAll && session.getOwner().isAdministrator();
    }

    public static boolean isSystemComponent(ComponentModel model, String name) {
        return ReservedNames.isReserved(name) || model == ComponentModel.DATASPACE && AbstractDSLOperation.isSystemDataspace(name);
    }

    public static boolean isSystemComponent(String type, String name) {
        return ReservedNames.isReserved(name) || type.equals(DataspaceType.TSPACE.name()) && AbstractDSLOperation.isSystemDataspace(name);
    }

    public static boolean isSystemComponent(String fullComponentName) throws Exception {
        List<String> tokens = ModeratorUtils.splitComponentFullName(fullComponentName);
        return AbstractDSLOperation.isSystemComponent(tokens.get(1), tokens.get(2));
    }

    public static boolean isSystemDataspace(String name) {
        return SqlInvariants.isSystemSchemaName(name) || SqlInvariants.isLobsSchemaName(name) || name.equals("SDS") || name.equals("RDS") || name.equals("SCH") || AbstractDSLOperation.isSystemUserOrQuiltDataspace(name);
    }

    private static boolean isSystemUserOrQuiltDataspace(String name) {
        return name.contains("usr$") || name.contains("qlt$");
    }

    public static boolean isReservedEvent(String eventId) {
        return ReservedSubjects.isReserved(eventId);
    }

    public static boolean isSystemEvent(String eventId) {
        return SystemEvents.isSystem(eventId) || SystemAdvisories.isSystem(eventId) || SystemExceptions.isSystem(eventId);
    }

    public static boolean isPredefinedEvent(String eventId) {
        return SystemEvents.isPredefined(eventId);
    }

    public static boolean isNonUserEvent(String eventId) {
        return AbstractDSLOperation.isReservedEvent(eventId) || AbstractDSLOperation.isSystemEvent(eventId) || AbstractDSLOperation.isPredefinedEvent(eventId);
    }

    public static boolean isUserEvent(String eventId) {
        return !AbstractDSLOperation.isNonUserEvent(eventId);
    }

    public static boolean isVisibleEvent(String eventId) {
        return VISIBLE_SYSTEM_EVENTS.contains(eventId);
    }

    protected static Modifier createLikeModifier() {
        return AbstractDSLOperation.createLikeModifier(false);
    }

    protected static Modifier createLikeModifier(boolean required) {
        return AbstractDSLOperation.createLikeModifier("LikePattern", required);
    }

    protected static Modifier createLikeModifier(String parameterName, boolean required) {
        return (Modifier)new Modifier("LIKE", required).addParameter((SyntaxParameter)new StringParameter("Pattern").setName(parameterName));
    }

    protected static Modifier createLikeModifierWithUniqueName(String parameterName, boolean required) {
        return (Modifier)AbstractDSLOperation.createLikeModifier(parameterName, required).setName("LIKE_" + parameterName);
    }

    protected static String getLikeModifierDescription(String indent, String newLines) {
        return indent + "Parameter Pattern should be put in quotes. It is a standard Java regular expression.\n" + indent + "In addition to the standard Regexp, the symbol % is used as alias for .* rule." + newLines;
    }

    protected static String getLikeParameterValue(DSLStatement statement) {
        return AbstractDSLOperation.getLikeParameterValue(statement, "LikePattern");
    }

    protected static String getLikeParameterValue(DSLStatement statement, String parameterName) {
        return statement.existsParameter(parameterName) ? statement.getParameter(parameterName).getValue() : null;
    }

    protected CompoundModifier createPropertyNameModifier(String parameterName) {
        return new CompoundModifier("PropertyModifier").addParameter(new IdentifierParameter(parameterName));
    }

    protected ChoiceModifier createPropertyTypeModifier(String name) {
        return this.createPropertyTypeModifier(name, PropertyTypes.ALL);
    }

    protected ChoiceModifier createPropertyTypeModifier(String name, PropertyTypes propertyTypes) {
        return (ChoiceModifier)new ChoiceModifier(name).addPossibleValuesExcept(PropertyValue.Type.class, this.getExcludedPropertyTypes(propertyTypes)).addPossibleValue("Int").setCompactSyntax(this.getCompactSyntax(propertyTypes));
    }

    protected ChoiceModifier createPropertyTypeModifierExtended(PropertyTypes propertyTypes, boolean withDate, String indent, boolean required) {
        ChoiceModifier type = this.createPropertyTypeModifier("Type", propertyTypes);
        type.addModifier(this.createBigDecimalPropertyModifier(false));
        if (withDate) {
            type.addModifier(this.createDateModifier());
        }
        type.setCompactSyntax(type.getSyntax().replace("}", (String)(indent != null ? "|\n" + indent : "| ") + "decimal [(&lt;Precision&gt;, &lt;Scale&gt;)]" + (withDate ? " | date [('&lt;Format&gt;')]" : "") + " }"));
        type.setRequired(required);
        if (!required) {
            type.setCompactSyntax("[" + type.getSyntax() + "]");
        }
        return type;
    }

    private Object[] getExcludedPropertyTypes(PropertyTypes propertyTypes) {
        switch (propertyTypes.ordinal()) {
            case 0: {
                return EXCLUDED_TYPES;
            }
            case 1: {
                return EXCLUDED_TYPES_NO_BOOLEAN;
            }
            case 2: {
                return EXCLUDED_TYPES_NUMERIC_ONLY;
            }
        }
        throw new RuntimeException("Invalid PropertyTypeSelection!");
    }

    private String getCompactSyntax(PropertyTypes propertyTypes) {
        switch (propertyTypes.ordinal()) {
            case 0: {
                return COMPACT_SYNTAX;
            }
            case 1: {
                return COMPACT_SYNTAX_NO_BOOLEAN;
            }
            case 2: {
                return COMPACT_SYNTAX_NUMERIC_ONLY;
            }
        }
        throw new RuntimeException("Invalid PropertyTypeSelection!");
    }

    protected CompoundModifier createBigDecimalPropertyModifier(boolean precisionRequired) {
        return new CompoundModifier("BigDecimalCompound").addModifier((AbstractModifier)new Modifier("Decimal").setAlias("BigDecimal")).addModifier(((SetModifier)new SetModifier("PrecisionSet").setRequired(precisionRequired)).addModifier((AbstractModifier)new Modifier().addParameter(new IntegerParameter("precision"))).addModifier((AbstractModifier)new Modifier().addParameter(new IntegerParameter("scale"))));
    }

    protected CompoundModifier createDateModifier() {
        return new CompoundModifier().addModifier(new Modifier("Date")).addModifier(((SetModifier)new SetModifier("FormatSet").setRequired(false)).addModifier((AbstractModifier)new Modifier().addParameter(new StringParameter("Format"))));
    }

    protected RepeatableModifier wrapToRepeatable(AbstractModifier modifier) {
        return (RepeatableModifier)new RepeatableModifier(modifier.getName() + "line").addModifier(modifier);
    }

    protected static PropertyType getPropertyType(String typeName) throws Exception {
        try {
            return typeName.equalsIgnoreCase("int") ? PropertyType.Integer : PropertyValue.Type.toPropertyType(typeName);
        }
        catch (IllegalArgumentException exception) {
            throw new FabricException("Invalid property type '" + typeName + "'.");
        }
    }

    protected void parseTypeAndFormat(AbstractStatementValueList statement, PropertyValue value) throws ParsingException {
        if (statement.existsModifier("Type")) {
            String type = statement.getModifier("Type").getToken();
            value.type = type.equalsIgnoreCase("int") ? PropertyValue.Type.INTEGER : PropertyValue.Type.valueOf(type.toUpperCase());
        } else if (statement.existsModifier("Decimal")) {
            value.type = PropertyValue.Type.DECIMAL;
            if (statement.existsSet("PrecisionSet")) {
                StatementSetValue precisionSet = statement.getSet("PrecisionSet");
                value.precision = Integer.parseInt(precisionSet.getElement(0).getParameter("precision").getValue());
                value.scale = Integer.parseInt(precisionSet.getElement(1).getParameter("scale").getValue());
                if (value.precision <= 0 || value.scale < 0 || value.precision > 128 || value.scale > value.precision) {
                    throw new ParsingException("Invalid precision/scale specified for property '" + value.value + "'.");
                }
            }
        } else if (statement.existsModifier("Date")) {
            value.type = PropertyValue.Type.DATE;
            value.format = AbstractDSLOperation.getFormat(statement);
        }
    }

    protected Object parseValue(PropertyValue value, boolean withBoolean) throws Exception {
        if (value.isTyped()) {
            return this.parseValueTyped(value);
        }
        if (value.inQuotes()) {
            return value.trimQuotes();
        }
        return AbstractDSLOperation.parseValueNumeric(value.getValue(), withBoolean);
    }

    protected static Object parseValueNumeric(String value, boolean withBoolean) throws Exception {
        if (withBoolean) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex1) {
            try {
                return Byte.parseByte(value);
            }
            catch (NumberFormatException ex2) {
                try {
                    return Short.parseShort(value);
                }
                catch (NumberFormatException ex4) {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (NumberFormatException ex5) {
                        try {
                            return Double.parseDouble(value);
                        }
                        catch (NumberFormatException ex6) {
                            try {
                                return Float.valueOf(Float.parseFloat(value));
                            }
                            catch (NumberFormatException ex7) {
                                try {
                                    return new BigDecimal(value);
                                }
                                catch (NumberFormatException ex8) {
                                    throw new Exception("Value '" + value + "' is invalid.");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object parseValueTyped(PropertyValue property) throws Exception {
        try {
            if (property.type == PropertyValue.Type.STRING) {
                this.checkStringValue(property);
            }
            String value = property.trimQuotes();
            switch (property.type.ordinal()) {
                case 0: {
                    return value;
                }
                case 1: {
                    return Boolean.parseBoolean(value);
                }
                case 2: {
                    return Byte.parseByte(value);
                }
                case 3: {
                    return Short.parseShort(value);
                }
                case 4: {
                    return Integer.parseInt(value);
                }
                case 5: {
                    return Long.parseLong(value);
                }
                case 6: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case 7: {
                    return Double.parseDouble(value);
                }
                case 8: {
                    return property.precision != null ? new BigDecimal(value, new MathContext(property.precision)).setScale((int)property.scale, RoundingMode.HALF_UP) : new BigDecimal(value);
                }
                case 9: {
                    return AbstractDSLOperation.parseDateValue(value, property.format);
                }
            }
            throw new RuntimeException("Invalid PropertyValueType!");
        }
        catch (NumberFormatException exception) {
            throw new Exception(property.type.toPrintString() + " value '" + property.value + "' is invalid.");
        }
    }

    protected static Date parseDateValue(String value, String format) throws Exception {
        try {
            return (format != null ? new SimpleDateFormat(format) : SCHEDULER_DATE_FORMAT).parse(value);
        }
        catch (ParseException exception) {
            throw new ParsingException(exception.getMessage());
        }
    }

    protected static String getFormat(AbstractStatementValueList statement) {
        return statement.existsSet("FormatSet") ? statement.getSet("FormatSet").getElement(0).getParameter("Format").getValue() : null;
    }

    protected void checkStringValue(PropertyValue property) throws Exception {
        if (!property.inQuotes()) {
            throw new ParsingException(this.getSyntaxErrorMessage("Value '" + property.value + "' is not a valid String. It must be in single quotes."));
        }
    }

    static {
        VISIBLE_SYSTEM_EVENTS.add("advisory.Runtime");
        VISIBLE_SYSTEM_EVENTS.add("advisory.Security");
        VISIBLE_SYSTEM_EVENTS.add("advisory.connection.StateChange");
        VISIBLE_SYSTEM_EVENTS.add("advisory.ds.metric");
        VISIBLE_SYSTEM_EVENTS.add("advisory.ds.notif");
        VISIBLE_SYSTEM_EVENTS.add("advisory.exec.EventTrigger");
        VISIBLE_SYSTEM_EVENTS.add("advisory.fabric.Exchange");
        VISIBLE_SYSTEM_EVENTS.add("advisory.fabric.Moderator");
        VISIBLE_SYSTEM_EVENTS.add("advisory.repository.ArtifactChange");
        VISIBLE_SYSTEM_EVENTS.add("advisory.service.metric");
        VISIBLE_SYSTEM_EVENTS.add("advisory.service.notif");
        VISIBLE_SYSTEM_EVENTS.add("advisory.stats.CpuThreshold");
        VISIBLE_SYSTEM_EVENTS.add("advisory.stats.DiskThreshold");
        VISIBLE_SYSTEM_EVENTS.add("advisory.stats.MemoryThreshold");
        VISIBLE_SYSTEM_EVENTS.add("advisory.component.StateChange");
        VISIBLE_SYSTEM_EVENTS.add("advisory.service.Call");
        VISIBLE_SYSTEM_EVENTS.add("event.Scheduler");
        VISIBLE_SYSTEM_EVENTS.add("event.Timer");
        VISIBLE_SYSTEM_EVENTS.add("event.ds.hdfs.job");
        VISIBLE_SYSTEM_EVENTS.add("event.xmpp.message");
        VISIBLE_SYSTEM_EVENTS.add("event.log.Trace");
        VISIBLE_SYSTEM_EVENTS.add("event.log.monitor.Stream");
        EXCLUDED_TYPES = new Object[]{PropertyValue.Type.DATE, PropertyValue.Type.DECIMAL};
        EXCLUDED_TYPES_NO_BOOLEAN = new Object[]{PropertyValue.Type.DATE, PropertyValue.Type.DECIMAL, PropertyValue.Type.BOOLEAN};
        EXCLUDED_TYPES_NUMERIC_ONLY = new Object[]{PropertyValue.Type.DATE, PropertyValue.Type.DECIMAL, PropertyValue.Type.BOOLEAN, PropertyValue.Type.STRING};
    }

    protected static enum PropertyTypes {
        ALL,
        NO_BOOLEAN,
        NUMERIC_ONLY;

    }

    protected static class PropertyValue {
        private Type type;
        private String value;
        private Integer precision;
        private Integer scale;
        private String format;

        public PropertyValue(String value) {
            this.value = value;
        }

        public PropertyValue(String value, PropertyValue other) {
            this(value);
            this.type = other.type;
            this.precision = other.precision;
            this.scale = other.scale;
            this.format = other.format;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isTyped() {
            return this.type != null;
        }

        public String getValue() {
            return this.value;
        }

        public boolean inQuotes() {
            return this.value.startsWith("'") && this.value.endsWith("'");
        }

        public String trimQuotes() {
            return this.inQuotes() ? this.value.substring(1, this.value.length() - 1) : this.value;
        }

        public PropertyType toPropertyType() {
            switch (this.type.ordinal()) {
                case 0: {
                    return PropertyType.String;
                }
                case 1: {
                    return PropertyType.Boolean;
                }
                case 2: {
                    return PropertyType.Byte;
                }
                case 3: {
                    return PropertyType.Short;
                }
                case 4: {
                    return PropertyType.Integer;
                }
                case 5: {
                    return PropertyType.Long;
                }
                case 6: {
                    return PropertyType.Float;
                }
                case 7: {
                    return PropertyType.Double;
                }
                case 8: {
                    return PropertyType.BigDecimal;
                }
            }
            return null;
        }

        public static enum Type {
            STRING,
            BOOLEAN,
            BYTE,
            SHORT,
            INTEGER,
            LONG,
            FLOAT,
            DOUBLE,
            DECIMAL,
            DATE;


            public static Type resolveType(Object value) {
                if (value instanceof String) {
                    return STRING;
                }
                if (value instanceof Boolean) {
                    return BOOLEAN;
                }
                if (value instanceof Byte) {
                    return BYTE;
                }
                if (value instanceof Short) {
                    return SHORT;
                }
                if (value instanceof Integer) {
                    return INTEGER;
                }
                if (value instanceof Long) {
                    return LONG;
                }
                if (value instanceof Float) {
                    return FLOAT;
                }
                if (value instanceof Double) {
                    return DOUBLE;
                }
                if (value instanceof BigDecimal) {
                    return DECIMAL;
                }
                if (value instanceof Date) {
                    return DATE;
                }
                return null;
            }

            public PropertyType toPropertyType() {
                switch (this.ordinal()) {
                    case 0: {
                        return PropertyType.String;
                    }
                    case 1: {
                        return PropertyType.Boolean;
                    }
                    case 2: {
                        return PropertyType.Byte;
                    }
                    case 3: {
                        return PropertyType.Short;
                    }
                    case 4: {
                        return PropertyType.Integer;
                    }
                    case 5: {
                        return PropertyType.Long;
                    }
                    case 6: {
                        return PropertyType.Float;
                    }
                    case 7: {
                        return PropertyType.Double;
                    }
                    case 8: {
                        return PropertyType.BigDecimal;
                    }
                }
                return null;
            }

            public static PropertyType toPropertyType(String typeName) {
                return Type.valueOf(typeName).toPropertyType();
            }

            public String toPrintString() {
                return StringUtils.toCapitalized(this.name().toLowerCase());
            }
        }
    }

    protected static class ProgressMonitor
    extends MonitorWorker {
        private AbstractDSLOperation operation;
        private MFSession session;

        public ProgressMonitor(AbstractDSLOperation operation, MFSession session) throws FabricException {
            super("FSYS:SLANG.ProgressMonitor", "Monitors a current progress of '" + operation.getName() + "' operation.", 1000L);
            this.operation = operation;
            this.session = session;
        }

        @Override
        protected void doExecute() throws FabricException {
            this.operation.raiseSLMessage(".", this.session);
        }
    }

    public class AsyncFeedbackInvoker
    implements FeedbackInvoker,
    Closeable {
        private MFSession session;
        private ProgressMonitor progressMonitor;

        public AsyncFeedbackInvoker(MFSession session) throws Exception {
            this.session = session;
            this.progressMonitor = new ProgressMonitor(AbstractDSLOperation.this, session);
            this.progressMonitor.start();
            this.progressMonitor.sleep();
        }

        @Override
        public MFSession getMFSession() {
            return this.session;
        }

        @Override
        public ProgressMonitor getProgressMonitor() {
            return this.progressMonitor;
        }

        @Override
        public void addFeedback(String message) {
            try {
                AbstractDSLOperation.this.raiseSLMessage(message, this.session);
            }
            catch (Exception exception) {
                Trace.logException(AbstractDSLOperation.this, exception, true);
            }
        }

        @Override
        public void addOK() {
            this.addFeedback(" OK\n");
        }

        @Override
        public void addWarning(String message) {
            try {
                AbstractDSLOperation.this.raiseSLMessageWarning(message, this.session);
            }
            catch (Exception exception) {
                Trace.logException(AbstractDSLOperation.this, exception, true);
            }
        }

        @Override
        public void addLongFeedback(String message) {
            this.addFeedback(message);
            Utils.sleep(50L);
            this.progressMonitor.wakeUp();
        }

        @Override
        public void completeLongFeedback() {
            this.progressMonitor.sleep();
            this.addOK();
        }

        @Override
        public void close() throws IOException {
            if (this.progressMonitor != null) {
                this.progressMonitor.stop();
                this.progressMonitor = null;
            }
        }
    }

    public static interface FeedbackInvoker {
        public MFSession getMFSession();

        public ProgressMonitor getProgressMonitor();

        public void addFeedback(String var1);

        public void addOK();

        public void addWarning(String var1);

        public void addLongFeedback(String var1);

        public void completeLongFeedback();
    }

    protected static class OperationResult {
        private RowSet rowSet;

        public OperationResult(RowMetaData descriptor) {
            this.rowSet = new RowSet(descriptor);
        }

        public OperationResult add(Object ... values) {
            AbstractDSLOperation.addValues(this.rowSet, Arrays.stream(values).filter(value -> !(value instanceof OptionalValue) || ((OptionalValue)value).isPresent()).map(value -> value instanceof OptionalValue ? ((OptionalValue)value).value : value).toArray());
            return this;
        }

        public SLResponse getResponse() {
            return new SLResponse(this.rowSet);
        }

        public SLResponse getResponse(Object ... values) {
            this.add(values);
            return new SLResponse(this.rowSet);
        }
    }

    protected static class OptionalValue {
        private Object value = null;

        public OptionalValue(boolean condition, Supplier<Object> getter) {
            if (condition) {
                this.value = getter.get();
            }
        }

        protected boolean isPresent() {
            return this.value != null;
        }
    }

    public static abstract class AbstractCompletionAdviser<T>
    implements CompletionAdviser<T> {
        @Override
        public List<String> getCompletions(String script, String processedScript, T callable, MFSession session) {
            return this.doGetCompletions(processedScript, session);
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }

        protected abstract List<String> doGetCompletions(String var1, MFSession var2);
    }
}

