/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.file;

import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileMessageRaiser;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class SLFileUtils {
    private SLFileMessageRaiser raiser;
    private String filename;
    private int transferBufferSize;
    private boolean verbose = true;

    public SLFileUtils(SLFileMessageRaiser raiser, String filename, int transferBufferSize) {
        this.raiser = raiser;
        this.filename = filename;
        this.transferBufferSize = transferBufferSize;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    public void createFile(byte[] content, boolean overwrite) throws IOException {
        this.createFile(this.filename, content, overwrite);
    }

    public void createFile(InputStream content, boolean overwrite) throws IOException {
        this.createFile(this.filename, content, overwrite);
    }

    public void createFile(InputStream content, long contentSize, boolean overwrite) throws IOException {
        this.createFile(this.filename, content, contentSize, overwrite);
    }

    public void createFile(String fileName, byte[] content, boolean overwrite) throws IOException {
        this.createFile(fileName, new ByteArrayInputStream(content), content != null ? (long)content.length : 0L, overwrite);
    }

    public void createFile(String fileName, InputStream content, boolean overwrite) throws IOException {
        this.createFile(fileName, content, -1L, overwrite);
    }

    public void createFile(String fileName, InputStream content, long contentSize, boolean overwrite) throws IOException {
        try (SLFileOutputStream outputStream = null;){
            outputStream = this.createSLFileOutputStream(fileName);
            outputStream.setFileSize(contentSize == -1L ? (long)content.available() : contentSize);
            if (overwrite) {
                outputStream.open();
            } else {
                outputStream.create();
            }
            if (content != null) {
                int nRead;
                byte[] bytes = new byte[this.transferBufferSize];
                while (contentSize != 0L && (nRead = content.read(bytes, 0, contentSize < 0L || contentSize > (long)this.transferBufferSize ? this.transferBufferSize : (int)contentSize)) > 0) {
                    if (contentSize > 0L) {
                        contentSize -= (long)nRead;
                    }
                    outputStream.write(bytes, 0, nRead);
                }
            }
        }
    }

    public byte[] getFileContent() throws IOException {
        return this.getFileContent(this.filename);
    }

    public byte[] getFileContent(String fileName) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.readFile(fileName, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void readFile(OutputStream stream) throws IOException {
        this.readFile(this.filename, stream);
    }

    public void readFile(String fileName, OutputStream stream) throws IOException {
        try (SLFileInputStream inputStream = null;){
            int nRead;
            inputStream = this.createSLFileInputStream(fileName);
            inputStream.open();
            byte[] bytes = new byte[this.transferBufferSize];
            int offset = 0;
            while ((nRead = inputStream.read(bytes, offset, this.transferBufferSize)) > 0) {
                stream.write(bytes, 0, nRead);
            }
        }
    }

    public SLFileInputStream createSLFileInputStream() throws IOException {
        return this.doCreateSLFileInputStream(this.filename);
    }

    public SLFileInputStream createSLFileInputStream(String fileName) throws IOException {
        return this.doCreateSLFileInputStream(fileName);
    }

    private SLFileInputStream doCreateSLFileInputStream(String fileName) throws IOException {
        SLFileInputStream result = new SLFileInputStream(this.raiser, fileName);
        result.setVerbose(this.verbose);
        return result;
    }

    public SLFileOutputStream createSLFileOutputStream() throws IOException {
        return this.doCreateSLFileOutputStream(this.filename);
    }

    public SLFileOutputStream createSLFileOutputStream(String fileName) throws IOException {
        return this.doCreateSLFileOutputStream(fileName);
    }

    private SLFileOutputStream doCreateSLFileOutputStream(String fileName) throws IOException {
        SLFileOutputStream result = new SLFileOutputStream(this.raiser, fileName);
        result.setVerbose(this.verbose);
        return result;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean exists() throws IOException {
        return this.exists(this.filename);
    }

    public boolean exists(String fileName) throws IOException {
        return this.createSLFileInputStream(fileName).exists();
    }

    public boolean supportsExistsOperation() throws IOException {
        try {
            this.exists();
            return true;
        }
        catch (UnsupportedOperationException exception) {
            return false;
        }
    }

    public boolean isDirectory() throws IOException {
        return this.isDirectory(this.filename);
    }

    public boolean isDirectory(String fileName) throws IOException {
        return this.createSLFileInputStream(fileName).isDirectory();
    }

    public boolean supportsIsDirectoryOperation() throws IOException {
        try {
            this.isDirectory();
            return true;
        }
        catch (UnsupportedOperationException exception) {
            return false;
        }
    }

    public void createDirectory() throws IOException {
        this.createDirectory(this.filename);
    }

    public void createDirectory(String fileName) throws IOException {
        this.createSLFileInputStream(fileName).createDirectory();
    }

    public void createDirectory(String fileName, FilePermissions permissions) throws IOException {
        this.createSLFileInputStream(fileName).createDirectory(permissions);
    }

    public boolean supportsCreateDirectoryOperation() throws IOException {
        try {
            this.isDirectory();
            return true;
        }
        catch (UnsupportedOperationException exception) {
            return false;
        }
    }

    public List<String> listDirectory() throws IOException {
        return this.listDirectory(this.filename);
    }

    public List<String> listDirectory(String fileName) throws IOException {
        return this.createSLFileInputStream(fileName).listDirectory();
    }

    public void delete() throws IOException {
        this.delete(this.filename);
    }

    public void delete(String fileName) throws IOException {
        this.delete(fileName, false);
    }

    public void delete(String fileName, boolean recursive) throws IOException {
        this.createSLFileInputStream(fileName).delete(recursive);
    }

    public DSLCompletion complete() throws IOException {
        return this.complete(this.filename);
    }

    public DSLCompletion complete(String fileName) throws IOException {
        return this.createSLFileInputStream(fileName).complete();
    }

    public FileInfo getFileInfo(String path) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_GET_FILE_INFO);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
        return response.getFileInfos()[0];
    }

    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_LIST);
        fileMessage.setRecursive(recursive);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
        return Arrays.asList(response.getFileInfos());
    }

    public void copy(String src, String dst) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_COPY);
        fileMessage.setDstFilename(dst);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    public void move(String src, String dst) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_MOVE);
        fileMessage.setDstFilename(dst);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    public void rename(String src, String dst) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_RENAME);
        fileMessage.setDstFilename(dst);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    public void setOwner(String username, String groupname) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_SET_OWNER);
        fileMessage.setUsername(username);
        fileMessage.setGroupname(groupname);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    public void setPermissions(FilePermissions permissions) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_SET_PERMISSIONS);
        fileMessage.setPermissions(permissions);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    public void createNewFile(FilePermissions permissions) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.FILE_SYSTEM_CREATE_NEW_FILE);
        fileMessage.setPermissions(permissions);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    protected SLFileMessage createFileMessage(SLFileMessage.FileOperation operation) {
        SLFileMessage fileMessage = new SLFileMessage();
        fileMessage.setOperation(operation);
        fileMessage.setFilename(this.filename);
        fileMessage.setVerbose(this.verbose);
        return fileMessage;
    }

    protected SLFileMessage raiseSLFileMessage(SLFileMessage fileMessage) throws IOException {
        return this.raiser.raise(fileMessage, -1L);
    }

    private void checkUnsupportedOperation(SLFileMessage response) {
        if (response.isNotSupported()) {
            throw new UnsupportedOperationException(response.toString());
        }
    }
}

