/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.file;

import com.streamscape.ds.persist.RandomAccessInputStream;
import com.streamscape.lib.fs.client.AbstractFileSystem;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.slex.file.SLFileMessageRaiser;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.file.SLFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;

public class SLFileSystem
extends AbstractFileSystem {
    private final SLFileMessageRaiser raiser;
    private final int transferBufferSize;
    private final SLFileUtils slFileUtils;

    SLFileSystem(SLFileMessageRaiser raiser, int transferBufferSize) {
        this.raiser = raiser;
        this.transferBufferSize = transferBufferSize;
        this.slFileUtils = new SLFileUtils(raiser, null, transferBufferSize);
    }

    @Override
    public int getDefaultBufferSize() {
        return this.transferBufferSize;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.raiser != null) {
            this.raiser.close();
        }
    }

    @Override
    public URI getPathURI(String path) throws IOException {
        return new File(path).getCanonicalFile().toURI();
    }

    @Override
    public FileInfo getInfo(String path) throws IOException {
        return new SLFileUtils(this.raiser, path, this.transferBufferSize).getFileInfo(path);
    }

    @Override
    public List<FileInfo> list(String path, boolean recursive) throws IOException {
        return new SLFileUtils(this.raiser, path, this.transferBufferSize).list(path, recursive);
    }

    @Override
    public void mkdir(String path, FilePermissions permissions) throws IOException {
        new SLFileUtils(this.raiser, path, this.transferBufferSize).createDirectory(path, permissions);
    }

    @Override
    public String createTempFile(String dir, String prefix, String suffix) throws IOException {
        throw new IOException("createTempFile is not supported for SL file system");
    }

    @Override
    public void createNewFile(String path, FilePermissions permissions) throws IOException {
        new SLFileUtils(this.raiser, path, this.transferBufferSize).createNewFile(permissions);
    }

    @Override
    public OutputStream create(String path, boolean overwrite, FilePermissions permissions, int bufferSize) throws IOException {
        return new SLFileUtils(this.raiser, path, bufferSize).createSLFileOutputStream(path).create(overwrite, permissions);
    }

    @Override
    public OutputStream append(String path, int bufferSize) throws IOException {
        return new SLFileUtils(this.raiser, path, bufferSize).createSLFileOutputStream(path).openForAppend();
    }

    @Override
    public OutputStream openForWrite(String path, int bufferSize) throws IOException {
        return new SLFileUtils(this.raiser, path, bufferSize).createSLFileOutputStream(path).open();
    }

    @Override
    public void writeFileFromInputStream(String path, InputStream inputStream, int bufferSize) throws IOException {
        try (SLFileOutputStream outputStream = new SLFileUtils(this.raiser, path, bufferSize).createSLFileOutputStream(path).open();
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            FileIOUtils.copyLarge(inputStream, (OutputStream)bufferedOutputStream);
        }
        catch (UtilitiesException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream open(String path, int bufferSize) throws IOException {
        return new SLFileUtils(this.raiser, path, bufferSize).createSLFileInputStream(path).open();
    }

    @Override
    public RandomAccessInputStream openForRandomRead(String path, int bufferSize) throws IOException {
        throw new IOException("Random access is not supported for SLFileSystem.");
    }

    @Override
    public boolean delete(String path, boolean recursive) throws IOException {
        new SLFileUtils(this.raiser, path, this.transferBufferSize).delete(path, recursive);
        return true;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return new SLFileUtils(this.raiser, path, this.transferBufferSize).exists(path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.getInfo(path).isFile();
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.getInfo(path).isDirectory();
    }

    @Override
    public void copy(String src, String dst) throws IOException {
        new SLFileUtils(this.raiser, src, this.transferBufferSize).copy(src, dst);
    }

    @Override
    public void rename(String src, String dst) throws IOException {
        new SLFileUtils(this.raiser, src, this.transferBufferSize).rename(src, dst);
    }

    @Override
    public void move(String src, String dst) throws IOException {
        new SLFileUtils(this.raiser, src, this.transferBufferSize).move(src, dst);
    }

    @Override
    public void setOwner(String path, String username, String groupname) throws IOException {
        new SLFileUtils(this.raiser, path, this.transferBufferSize).setOwner(username, groupname);
    }

    @Override
    public void setPermissions(String path, FilePermissions permissions) throws IOException {
        new SLFileUtils(this.raiser, path, this.transferBufferSize).setPermissions(permissions);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public long truncate(String path, long size) throws IOException {
        throw new IOException("truncate is not supported for SL file system");
    }
}

