/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.file;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.slex.file.SLFileMessageRaiser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class SLFileOutputStream
extends OutputStream {
    public static final long DEFAULT_TIMEOUT = -1L;
    private String filename;
    private long writeTimeout = -1L;
    private boolean isClosed = true;
    private long fileSize = -1L;
    private long processedSize = 0L;
    private boolean isError = false;
    private boolean verbose = true;
    private SLFileMessageRaiser raiser;

    protected SLFileOutputStream(SLFileMessageRaiser raiser, String filename) {
        this.raiser = raiser;
        this.filename = filename;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public SLFileOutputStream open() throws IOException {
        try {
            this.raiser.open();
            this.isClosed = false;
            this.raiseSLFileMessage(this.createFileMessage(SLFileMessage.FileOperation.OPEN_FOR_WRITE));
            return this;
        }
        catch (FileNotFoundException exception) {
            throw new IOException("Creation of file '" + this.filename + "' failed.", exception);
        }
    }

    public SLFileOutputStream openForAppend() throws IOException {
        this.raiser.open();
        this.isClosed = false;
        this.raiseSLFileMessage(this.createFileMessage(SLFileMessage.FileOperation.OPEN_FOR_APPEND));
        return this;
    }

    public SLFileOutputStream create() throws IOException {
        return this.create(false, null);
    }

    public SLFileOutputStream create(boolean overwrite, FilePermissions permissions) throws IOException {
        try {
            this.raiser.open();
            this.isClosed = false;
            this.raiseSLFileMessage(this.createFileMessage(SLFileMessage.FileOperation.CREATE).setOverwrite(overwrite).setPermissions(permissions));
            return this;
        }
        catch (FileNotFoundException exception) {
            throw new IOException("Creation of file '" + this.filename + "' failed.", exception);
        }
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        try {
            this.raiseSLFileMessage(this.createFileMessage(SLFileMessage.FileOperation.CLOSE_WRITING));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        this.raiser.close();
        this.isClosed = true;
    }

    @Override
    public void write(int b) throws IOException {
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.WRITE);
        fileMessage.setLength(1L);
        fileMessage.setBytes(new byte[]{(byte)b});
        this.raiseSLFileMessage(fileMessage);
        ++this.processedSize;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.WRITE);
        fileMessage.setLength(len);
        if (off != 0 || b.length != len) {
            b = Arrays.copyOfRange(b, off, len + off);
        }
        fileMessage.setBytes(b);
        this.raiseSLFileMessage(fileMessage);
        this.processedSize += (long)len;
    }

    protected SLFileMessage raiseSLFileMessage(SLFileMessage fileMessage) throws IOException {
        return this.raiser.raise(fileMessage, this.writeTimeout);
    }

    protected SLFileMessage createFileMessage(SLFileMessage.FileOperation operation) {
        SLFileMessage fileMessage = new SLFileMessage();
        fileMessage.setOperation(operation);
        fileMessage.setFilename(this.filename);
        fileMessage.setLengthTotal(this.fileSize);
        fileMessage.setLengthProcessed(this.processedSize);
        fileMessage.setVerbose(this.verbose);
        if (this.isError) {
            fileMessage.setError();
        }
        return fileMessage;
    }

    void setError() {
        this.isError = true;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

