/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.file;

import com.streamscape.Trace;
import com.streamscape.lib.fs.client.FilePermissions;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.slex.file.SLFileMessageRaiser;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SLFileInputStream
extends InputStream {
    public static long DEFAULT_TIMEOUT = -1L;
    private String filename;
    private long readTimeout = DEFAULT_TIMEOUT;
    private boolean isClosed = true;
    private long fileLength = -1L;
    private long processedSize = 0L;
    private long skipped = 0L;
    private boolean isError = false;
    private boolean verbose = true;
    private SLFileMessageRaiser raiser;

    protected SLFileInputStream(SLFileMessageRaiser raiser, String filename) {
        this.raiser = raiser;
        this.filename = filename;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public SLFileInputStream open() throws IOException {
        this.raiser.open();
        this.isClosed = false;
        this.fileLength = this.raiseSLFileMessage(this.createFileMessage(SLFileMessage.FileOperation.OPEN_FOR_READ)).getLength();
        return this;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        try {
            this.raiseSLFileMessage(this.createFileMessage(SLFileMessage.FileOperation.CLOSE_READING));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        this.raiser.close();
        this.isClosed = true;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    @Override
    public int read() throws IOException {
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.READ);
        fileMessage.setLength(1L);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        if (response.getLength() != 1L) {
            return (int)response.getLength();
        }
        this.processedSize += response.getLength();
        return response.getBytes()[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.READ);
        fileMessage.setLength(len);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        if (response.getLength() == -1L) {
            return -1;
        }
        if (response.getLength() == 0L) {
            return 0;
        }
        this.processedSize += response.getLength();
        len = Math.min((int)response.getLength(), len);
        System.arraycopy(response.getBytes(), 0, b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.SKIP);
        fileMessage.setLength(n);
        long result = this.raiseSLFileMessage(fileMessage).getLength();
        this.skipped += result;
        return result;
    }

    @Override
    public int available() throws IOException {
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.AVAILABLE_FOR_READ);
        return (int)this.raiseSLFileMessage(fileMessage).getLength();
    }

    protected boolean exists() throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.EXISTS);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
        return response.getLength() == 1L;
    }

    protected boolean isDirectory() throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.IS_DIRECTORY);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
        return response.getLength() == 1L;
    }

    protected List<String> listDirectory() throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.LIST_DIRECTORY);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
        List<String> result = response.getFiles();
        if (result == null) {
            result = new ArrayList<String>();
        }
        return result;
    }

    protected void createDirectory() throws IOException {
        this.createDirectory(null);
    }

    protected void createDirectory(FilePermissions permissions) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.CREATE_DIRECTORY);
        fileMessage.setPermissions(permissions);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
    }

    protected void delete(boolean recursive) throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.REMOVE);
        fileMessage.setRecursive(recursive);
        this.raiseSLFileMessage(fileMessage);
    }

    protected DSLCompletion complete() throws IOException {
        this.raiser.open();
        SLFileMessage fileMessage = this.createFileMessage(SLFileMessage.FileOperation.COMPLETE);
        SLFileMessage response = this.raiseSLFileMessage(fileMessage);
        this.checkUnsupportedOperation(response);
        return response.getDSLCompletion();
    }

    private void checkUnsupportedOperation(SLFileMessage response) {
        if (response.isNotSupported()) {
            throw new UnsupportedOperationException(response.toString());
        }
    }

    protected SLFileMessage raiseSLFileMessage(SLFileMessage fileMessage) throws IOException {
        return this.raiser.raise(fileMessage, this.readTimeout);
    }

    protected SLFileMessage createFileMessage(SLFileMessage.FileOperation operation) {
        SLFileMessage fileMessage = new SLFileMessage();
        fileMessage.setOperation(operation);
        fileMessage.setFilename(this.filename);
        fileMessage.setLengthProcessed(this.processedSize);
        fileMessage.setLengthTotal(this.fileLength - this.skipped);
        fileMessage.setVerbose(this.verbose);
        if (this.isError) {
            fileMessage.setError();
        }
        return fileMessage;
    }

    void setError() {
        this.isError = true;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

