/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WavFileWriter {
    public static void writeWavFile(OutputStream outputStream, AudioFormat audioFormat, byte[] audioBytes) throws IOException {
        AudioInputStream audioInputStream = WavFileWriter.convertToAudioInputStream(audioBytes, audioFormat);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, outputStream);
    }

    public static AudioInputStream convertToAudioInputStream(byte[] audioBytes, AudioFormat audioFormat) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(audioBytes);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, audioBytes.length / audioFormat.getFrameSize());
        audioInputStream.reset();
        return audioInputStream;
    }

    public static long getAudioInputStreamDurationSeconds(AudioInputStream audioInputStream, AudioFormat audioFormat) {
        long milliseconds = (long)((float)(audioInputStream.getFrameLength() * 1000L) / audioFormat.getFrameRate());
        long duration = (long)((double)milliseconds / 1000.0);
        return duration;
    }
}

