/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.audio;

import com.streamscape.Trace;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.slex.audio.SLAudioMessageRaiser;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.sound.sampled.AudioFormat;

public class SLAudioInputStream
extends InputStream {
    public static long DEFAULT_TIMEOUT = 30000L;
    private String uniqueStreamId = UUID.randomUUID().toString();
    private AudioFormat audioFormat;
    private long readTimeout = DEFAULT_TIMEOUT;
    private boolean isClosed = true;
    private boolean isError = false;
    private boolean verbose = true;
    private long processedSize = 0L;
    private SLAudioMessageRaiser raiser;

    protected SLAudioInputStream(SLAudioMessageRaiser raiser, AudioFormat audioFormat) {
        this.raiser = raiser;
        this.audioFormat = audioFormat;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public SLAudioInputStream open() throws IOException {
        this.raiser.open();
        this.isClosed = false;
        SLAudioMessage response = this.raiseSLAudioMessage(this.createAudioMessage(SLAudioMessage.AudioOperation.OPEN_FOR_READ));
        this.audioFormat = response.getAudioFormat();
        return this;
    }

    public void closeReading() {
        if (this.isClosed) {
            return;
        }
        try {
            this.raiseSLAudioMessage(this.createAudioMessage(SLAudioMessage.AudioOperation.CLOSE_READING));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        try {
            this.raiseSLAudioMessage(this.createAudioMessage(SLAudioMessage.AudioOperation.CLOSE_READING));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        this.raiser.close();
        this.isClosed = true;
    }

    @Override
    public int read() throws IOException {
        SLAudioMessage audioMessage = this.createAudioMessage(SLAudioMessage.AudioOperation.READ);
        audioMessage.setLength(1);
        SLAudioMessage response = this.raiseSLAudioMessage(audioMessage);
        if (response.getLength() != 1) {
            return response.getLength();
        }
        this.processedSize += (long)response.getLength();
        return response.getBytes()[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        SLAudioMessage audioMessage = this.createAudioMessage(SLAudioMessage.AudioOperation.READ);
        audioMessage.setLength(len);
        SLAudioMessage response = this.raiseSLAudioMessage(audioMessage);
        if (response.getLength() == -1) {
            return -1;
        }
        if (response.getLength() == 0) {
            return 0;
        }
        this.processedSize += (long)response.getLength();
        len = Math.min(response.getLength(), len);
        System.arraycopy(response.getBytes(), 0, b, off, len);
        return len;
    }

    protected SLAudioMessage raiseSLAudioMessage(SLAudioMessage audioMessage) throws IOException {
        return this.raiser.raise(audioMessage, this.readTimeout);
    }

    protected SLAudioMessage createAudioMessage(SLAudioMessage.AudioOperation operation) {
        SLAudioMessage audioMessage = new SLAudioMessage();
        audioMessage.setOperation(operation);
        audioMessage.setVerbose(this.verbose);
        audioMessage.setAudioFormat(this.audioFormat);
        audioMessage.setUniqueStreamId(this.uniqueStreamId);
        if (this.isError) {
            audioMessage.setError();
        }
        return audioMessage;
    }

    void setError() {
        this.isError = true;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public long getProcessedSize() {
        return this.processedSize;
    }

    public SLAudioInputStream setUniqueStreamId(String uniqueStreamId) {
        this.uniqueStreamId = uniqueStreamId;
        return this;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }
}

