/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.audio;

import com.streamscape.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioMicrophoneReader {
    public static int DEFAULT_CHUNK_SIZE_BYTES = 4096;
    private AudioFormat audioFormat;
    private int chunkSizeBytes = DEFAULT_CHUNK_SIZE_BYTES;
    private List<AudioMicrophoneBytesListener> listeners = new ArrayList<AudioMicrophoneBytesListener>();
    private ExecutorService executor;
    private volatile boolean isRunning = false;
    private Future<?> future;
    private int totalBytesRead = 0;

    public AudioMicrophoneReader(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public void setChunkSizeBytes(int chunkSizeBytes) {
        this.chunkSizeBytes = chunkSizeBytes;
    }

    public void addListener(AudioMicrophoneBytesListener listener) {
        this.listeners.add(listener);
    }

    public List<AudioMicrophoneBytesListener> getListeners() {
        return new ArrayList<AudioMicrophoneBytesListener>(this.listeners);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        this.totalBytesRead = 0;
        MicrophoneReaderRunnable runnable = new MicrophoneReaderRunnable();
        this.executor = Executors.newSingleThreadExecutor();
        this.isRunning = true;
        this.future = this.executor.submit(runnable);
    }

    public void stop() {
        this.isRunning = false;
        while (true) {
            try {
                this.future.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
        this.future = null;
        this.executor.shutdown();
        this.executor = null;
    }

    public TargetDataLine getTargetDataLineForRecord() {
        TargetDataLine line;
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            return null;
        }
        try {
            line = (TargetDataLine)AudioSystem.getLine(info);
            line.open(this.audioFormat, line.getBufferSize());
        }
        catch (Exception ex) {
            return null;
        }
        return line;
    }

    private class MicrophoneReaderRunnable
    implements Runnable {
        private MicrophoneReaderRunnable() {
        }

        @Override
        public void run() {
            Trace.logInfo(this, "MicrophoneReaderRunnable start.");
            try (TargetDataLine line = AudioMicrophoneReader.this.getTargetDataLineForRecord();){
                int frameSizeInBytes = AudioMicrophoneReader.this.audioFormat.getFrameSize();
                int bufferLengthInFrames = line.getBufferSize() / 8;
                int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
                Trace.logInfo(this, "Reading audio in format: " + String.valueOf(line.getFormat()));
                Trace.logInfo(this, "frameSizeInBytes: " + frameSizeInBytes + ", bufferLengthInBytes: " + bufferLengthInBytes);
                this.readLineBytes(line, bufferLengthInBytes);
            }
            catch (IOException ex) {
                Trace.logException(this, ex, true);
            }
            catch (Exception ex) {
                Trace.logException(this, ex, true);
            }
            Trace.logInfo(this, "MicrophoneReaderRunnable finished.");
        }

        public void readLineBytes(TargetDataLine line, int bufferLengthInBytes) throws IOException {
            byte[] data = new byte[bufferLengthInBytes];
            byte[] chunk = new byte[AudioMicrophoneReader.this.chunkSizeBytes];
            int chunkOffset = 0;
            line.start();
            while (AudioMicrophoneReader.this.isRunning) {
                int numBytesRead = line.read(data, 0, bufferLengthInBytes);
                if (numBytesRead == -1) {
                    this.callListeners(chunk, chunkOffset, bufferLengthInBytes);
                    break;
                }
                AudioMicrophoneReader.this.totalBytesRead += numBytesRead;
                if (numBytesRead > chunk.length - chunkOffset) {
                    chunk = Arrays.copyOf(chunk, chunkOffset + numBytesRead);
                }
                System.arraycopy(data, 0, chunk, chunkOffset, numBytesRead);
                if ((chunkOffset += numBytesRead) < AudioMicrophoneReader.this.chunkSizeBytes) continue;
                this.callListeners(chunk, chunkOffset, bufferLengthInBytes);
                chunkOffset = 0;
            }
        }

        private void callListeners(byte[] chunk, int length, int bufferLengthInBytes) throws IOException {
            if (length > 0) {
                byte[] chunkCopy = Arrays.copyOf(chunk, length);
                for (AudioMicrophoneBytesListener listener : AudioMicrophoneReader.this.listeners) {
                    listener.onBytes(chunkCopy, bufferLengthInBytes);
                }
            }
        }
    }

    public static interface AudioMicrophoneBytesListener {
        public void onBytes(byte[] var1, int var2) throws IOException;
    }
}

