/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.audio;

import com.streamscape.ds.session.Session;
import com.streamscape.sef.dispatcher.SLAudioMessageRaiserLocal;
import com.streamscape.sef.dispatcher.SLAudioMessageRaiserRemote;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.audio.SLAudioMessageRaiser;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.slang.SLMessageListener;
import javax.sound.sampled.AudioFormat;

abstract class AbstractSLAudioStreamFactory<T> {
    AbstractSLAudioStreamFactory() {
    }

    public T create(MFSession session, AudioFormat audioFormat) {
        return this.create(session.getSLSessionData().getSLFileSessionContext(), session, audioFormat);
    }

    public T create(Session session, AudioFormat audioFormat) {
        return this.create(session.getSLFileSessionContext(), session.getComponentName(), session.getSLSessionName(), audioFormat, session.getTransferBufferSize(), session.getMFSession());
    }

    public T create(SLFileSessionContext context, MFSession session, AudioFormat audioFormat) {
        return this.doCreate(context, session, session.getComponentName(), session.getSLSessionName(), audioFormat, session.getSLSessionData().getTransferBufferSize());
    }

    public T create(SLFileSessionContext context, String componentName, String slSessionName, AudioFormat audioFormat) {
        return this.create(context, componentName, slSessionName, audioFormat, 0x500000, null);
    }

    public T create(SLFileSessionContext context, String componentName, String slSessionName, AudioFormat audioFormat, int transferBufferSize, MFSession session) {
        return this.onCreate(this.createSLAudioMessageRaiser(context, componentName, slSessionName, session), audioFormat, transferBufferSize);
    }

    public T create(String componentName, SLMessageListener responseListener, AudioFormat audioFormat, int transferBufferSize) {
        return this.onCreate(new SLAudioMessageRaiserRemote(componentName, responseListener), audioFormat, transferBufferSize);
    }

    private T doCreate(SLFileSessionContext context, MFSession session, String componentName, String slSessionName, AudioFormat audioFormat, int transferBufferSize) {
        return this.onCreate(this.createSLAudioMessageRaiser(context, componentName, slSessionName, session), audioFormat, transferBufferSize);
    }

    protected SLAudioMessageRaiser createSLAudioMessageRaiser(SLFileSessionContext context, String componentName, String slSessionName, MFSession mfSession) {
        switch (context) {
            case CLIENT: {
                return new SLAudioMessageRaiserRemote(componentName, slSessionName, mfSession);
            }
            case SERVER: {
                return new SLAudioMessageRaiserLocal(componentName, slSessionName);
            }
        }
        throw new RuntimeException("Invalid SLFileSessionContext!");
    }

    protected abstract T onCreate(SLAudioMessageRaiser var1, AudioFormat var2, int var3);
}

