/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

public enum SizeUnit {
    BYTES(new String[]{"bytes", "B"}){

        @Override
        public long toBytes(long size) {
            return size;
        }
    }
    ,
    KILOBYTES(new String[]{"Kb", "K"}){

        @Override
        public long toBytes(long size) {
            return size << 10;
        }
    }
    ,
    MEGABYTES(new String[]{"Mb", "M"}){

        @Override
        public long toBytes(long size) {
            return size << 20;
        }
    }
    ,
    GIGABYTES(new String[]{"Gb", "G"}){

        @Override
        public long toBytes(long size) {
            return size << 30;
        }
    }
    ,
    TRABYTES(new String[]{"Tb", "T"}){

        @Override
        public long toBytes(long size) {
            return size << 40;
        }
    };

    private String[] names;
    private static final long mask = 0xFFFFFFFFFFFFC00L;

    private SizeUnit(String ... names) {
        this.names = names;
    }

    public String getName() {
        return this.names[0];
    }

    public String[] getNames() {
        return this.names;
    }

    public static Size convertToBestEvent(long size, SizeUnit unit) {
        int i;
        for (i = unit.ordinal(); i < SizeUnit.values().length - 1 && size > 0L && (size & 0xFFFFFFFFFFFFC00L) == size; size >>= 10, ++i) {
        }
        return new Size(size, SizeUnit.values()[i]);
    }

    public static Size convertToBestFractional(long size, SizeUnit unit) {
        int i;
        Size result = null;
        for (i = unit.ordinal(); i < SizeUnit.values().length - 1 && size >= 1024L; ++i) {
            long a = size >> 10;
            long b = size - (a << 10);
            if (b != 0L) {
                if (result == null) {
                    result = new Size(b, SizeUnit.values()[i]);
                } else {
                    result.add(b, SizeUnit.values()[i]);
                }
            }
            size = a;
        }
        if (result == null) {
            result = new Size(size, SizeUnit.values()[i]);
        } else {
            result.add(size, SizeUnit.values()[i]);
        }
        return result;
    }

    public long toBytes(long size) {
        throw new AbstractMethodError();
    }

    public static SizeUnit valueByName(String name) {
        for (SizeUnit value : SizeUnit.values()) {
            for (String n : value.getNames()) {
                if (!n.equalsIgnoreCase(name)) continue;
                return value;
            }
        }
        throw new IllegalArgumentException("SizeUnit with name '" + name + "' doesn't exist.");
    }

    public static class Size {
        private long[] sizes = new long[SizeUnit.values().length];
        private SizeUnit[] units = new SizeUnit[SizeUnit.values().length];
        private int length = 0;

        Size(long size, SizeUnit unit) {
            this.sizes[0] = size;
            this.units[0] = unit;
            ++this.length;
        }

        public long getSize() {
            return this.sizes[this.length - 1];
        }

        public SizeUnit getUnit() {
            return this.units[this.length - 1];
        }

        public void add(long size, SizeUnit unit) {
            this.sizes[this.length] = size;
            this.units[this.length] = unit;
            ++this.length;
        }

        public String toString() {
            Object result = "";
            for (int i = this.length - 1; i >= 0; --i) {
                if (i < this.length - 1) {
                    result = (String)result + " ";
                }
                result = (String)result + this.sizes[i] + " " + this.units[i].getName();
            }
            return result;
        }

        public String toStringWithPrecision(int precision) {
            if (this.length > 1) {
                int i;
                double decimalPartBytes = 0.0;
                for (i = this.length - 2; i >= 0; --i) {
                    decimalPartBytes += (double)this.units[i].toBytes(this.sizes[i]);
                }
                for (i = 0; i < this.units[this.length - 1].ordinal(); ++i) {
                    decimalPartBytes /= 1024.0;
                }
                double result = (double)this.sizes[this.length - 1] + decimalPartBytes;
                return String.format("%." + precision + "f", result) + " " + this.units[this.length - 1].getName();
            }
            return this.sizes[this.length - 1] + " " + this.units[this.length - 1].getName();
        }
    }
}

