/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.parameter.NumericParameter;

public class SetTransferBufferSizeOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    public static final String NAME = "set transfer buffer size";
    public static String description = "Sets the transfer buffer size used by operations and functions that transfer files from/to client to/from server.\nNote: For Remote File Systems (i.e. HDFS) this controls the size of the buffer used to upload or download files.\n      For example when working with Directory Tables and large files it may make sense to increase the buffer size.";

    public SetTransferBufferSizeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET TRANSFER BUFFER SIZE").addActionParameter(new NumericParameter("transferBufferSize")).setSyntaxHintSpace();
        this.syntax.addModifier(new ChoiceModifier("SizeUnit").addPossibleValues(SizeUnit.BYTES.getName(), SizeUnit.KILOBYTES.getName(), SizeUnit.MEGABYTES.getName()));
        this.syntax.setDescription(description);
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        long transferBufferSize = Long.parseLong(statement.getParameter("transferBufferSize").getValue());
        transferBufferSize = SizeUnit.valueByName(statement.getModifier("SizeUnit").getToken()).toBytes(transferBufferSize);
        if (transferBufferSize > Integer.MAX_VALUE) {
            throw new ParsingException("Transfer buffer should be less than 2147483647 bytes.");
        }
        return new Definition((int)transferBufferSize);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.transferBufferSize <= 0) {
            throw new Exception("Transfer buffer should be greater than zero.");
        }
        session.getSLSessionData().setTransferBufferSize(definition.transferBufferSize);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private int transferBufferSize;

        protected Definition(int transferBufferSize) {
            super(SetTransferBufferSizeOperation.NAME);
            this.transferBufferSize = transferBufferSize;
        }
    }
}

