/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.EnumParameter;

public class SetSessionContextOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    public static final String NAME = "set session context";
    public static final String description = "Sets a default session context for the current session.\nIf session context is set to CLIENT then file operations will lookup for files on a client side.\nIf session context is set to SERVER then file operations will lookup for files on a server side.\nIn case of SERVER context the Dataspace file access restrictions will be applied.\nCurrent session context can be checked with 'describe session' command.\nAll interactive sessions by default have CLIENT context set. All internal sessions have SERVER context set by default.";

    public SetSessionContextOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET SESSION CONTEXT");
        this.syntax.addActionParameter(new EnumParameter("sessionContext", SLFileSessionContext.class, SLFileSessionContext.CLIENT, SLFileSessionContext.SERVER).setCaseSensitive(false));
        this.syntax.setDescription(description);
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(SLFileSessionContext.valueOf(statement.getParameter("sessionContext").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        session.getSLSessionData().setSLFileSessionContext(((Definition)statement).sessionContext);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private SLFileSessionContext sessionContext;

        protected Definition(SLFileSessionContext sessionContext) {
            super(SetSessionContextOperation.NAME);
            this.sessionContext = sessionContext;
        }
    }
}

