/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.parameter.EnumParameter;

public class SetDataObjectNotationOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    public static final String NAME = "set data object notation";

    public SetDataObjectNotationOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET DATA OBJECT NOTATION").addActionParameter(new EnumParameter("Notation", SLSessionData.DataObjectNotation.class));
        this.syntax.setDescription("Sets a data object notation used for objects returned from dataspace queries in SLANG session.\nNOTE: This setting is applicable for operation thru SLANG session only.");
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(SLSessionData.DataObjectNotation.valueOf(statement.getParameter("Notation").getValue().toLowerCase()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        session.getSLSessionData().setDataObjectNotation(((Definition)statement).notation);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private SLSessionData.DataObjectNotation notation;

        protected Definition(SLSessionData.DataObjectNotation notation) {
            super(SetDataObjectNotationOperation.NAME);
            this.notation = notation;
        }
    }
}

