/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.Operation;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconException;
import com.streamscape.slex.SemanticLexiconProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class SemanticLexiconManager {
    protected HashMap<String, HashSet<DSLProvider>> registeredProviders = new HashMap();

    protected SemanticLexiconManager() {
    }

    public void registerProvider(String componentType, DSLProvider provider) throws SemanticLexiconException {
        HashSet<DSLProvider> set = this.registeredProviders.get(componentType);
        if (set == null) {
            this.registeredProviders.put(componentType, new HashSet());
            set = this.registeredProviders.get(componentType);
        } else if (set.contains(provider)) {
            throw new SemanticLexiconException(7007, "Provider '" + provider.getName() + "' already registered.");
        }
        set.add(provider);
    }

    public boolean isProviderRegistered(String componentType, DSLProvider provider) {
        HashSet<DSLProvider> providersSet = this.registeredProviders.get(componentType);
        return providersSet != null && providersSet.contains(provider);
    }

    public List<DSLProvider> loadProviders(DSLComponent component) {
        HashSet<DSLProvider> providersSet = this.registeredProviders.get(component.getType());
        return providersSet != null ? new ArrayList<DSLProvider>(providersSet) : new ArrayList();
    }

    public abstract SemanticLexiconProcessor getBaseProcessor();

    public abstract Operation<?> getExportableOperation(String var1, MFSession var2);

    public abstract Set<String> listExportableOperations(MFSession var1, String var2);

    public abstract Set<String> listExportableOperationsByTag(String var1, MFSession var2);

    public abstract Set<String> listForeignTags(MFSession var1);
}

