/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.HelpDSLOperation;
import java.util.Set;

public abstract class HelpOperation<T extends SLCallable>
extends HelpDSLOperation<T> {
    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.existsModifier("ALL")) {
            return new Definition("ALL");
        }
        Definition result = new Definition(statement.getParameter("operation").getValue());
        result.setSyntaxOnly(statement.existsModifier("SYNTAX"));
        return result;
    }

    protected SLResponse invokeHelpWithoutParameters(boolean isComplex, Set<String> operations, MFSession session, String pattern) {
        return HelpOperation.convert(isComplex, new HelpSLResponse(operations));
    }

    protected static SLResponse convert(boolean isComplex, HelpSLResponse response) {
        return isComplex ? response : response.convertToUserResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String operationName = null;
        private boolean isComplex = false;
        private boolean syntaxOnly = false;

        public Definition(String operationName) {
            super("help");
            this.operationName = operationName;
        }

        public Definition(String operationName, boolean isComplex) {
            super("help");
            this.operationName = operationName;
            this.isComplex = isComplex;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public boolean isComplex() {
            return this.isComplex;
        }

        public void setComplex() {
            this.isComplex = true;
        }

        public boolean isSyntaxOnly() {
            return this.syntaxOnly;
        }

        public void setSyntaxOnly(boolean value) {
            this.syntaxOnly = value;
        }

        public boolean isList() {
            return this.operationName == null || this.operationName.equalsIgnoreCase("ALL");
        }

        public boolean isAll() {
            return this.operationName != null && this.operationName.equalsIgnoreCase("ALL");
        }
    }
}

