/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;

public class GetTransferBufferSizeOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    public static final String NAME = "get transfer buffer size";

    public GetTransferBufferSizeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("GET TRANSFER BUFFER SIZE");
        this.syntax.setDescription("Returns the transfer buffer size of the current session.");
        this.syntax.addTag(OperationTag.session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(GetTransferBufferSizeOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{SizeUnit.convertToBestFractional(session.getSLSessionData().getTransferBufferSize(), SizeUnit.BYTES).toString()});
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        GetTransferBufferSizeOperation.addColumn(result, "Transfer Buffer Size");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        protected Definition() {
            super(GetTransferBufferSizeOperation.NAME);
        }
    }
}

