/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.slex.MFContext;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.SLSessionDataImpl;
import com.streamscape.slex.file.SLFileUtilsFactory;

public abstract class AbstractMFSession
extends CloneableDataObject
implements MFSession {
    protected String name;
    protected String componentName;
    protected ComponentOwner owner;
    protected boolean isRouted;
    protected String slSessionName;
    protected SLSessionData slSessionData;
    protected String resourceName;
    protected Runnable interruptListener;

    public AbstractMFSession(String name, String componentName, ComponentOwner owner, boolean isRouted, String slSessionName, String resourceName) {
        this.name = name;
        this.componentName = componentName;
        this.owner = owner;
        this.isRouted = isRouted;
        this.slSessionName = slSessionName;
        this.slSessionData = new SLSessionDataImpl();
        this.resourceName = resourceName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public ComponentOwner getOwner() {
        return this.owner != null ? (ComponentOwner)this.owner.clone() : null;
    }

    @Override
    public String getOwnerName() {
        return this.owner != null ? this.owner.getName().toString() : null;
    }

    @Override
    public boolean isRouted() {
        return this.isRouted;
    }

    @Override
    public boolean isDiagnostic() {
        return false;
    }

    @Override
    public boolean isInstant() {
        return false;
    }

    @Override
    public MFContext getContext() {
        return null;
    }

    @Override
    public void setContext(MFContext context) {
    }

    @Override
    public String getSLSessionName() {
        return this.slSessionName;
    }

    @Override
    public void setSLSessionData(SLSessionData slSessionData) {
        this.slSessionData = slSessionData;
    }

    @Override
    public SLSessionData getSLSessionData() {
        return this.slSessionData;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public <T> SLFileUtilsFactory createSLFileUtilsFactory(T callable) {
        return new SLFileUtilsFactory();
    }

    @Override
    public boolean isFromSlangTool() {
        return AbstractMFSession.isFromSlangTool(this.componentName);
    }

    public static boolean isFromSlangTool(String componentName) {
        String componentType;
        if (componentName != null && (componentType = ModeratorUtils.extractComponentNameType(componentName)) != null) {
            return componentType.equals("Client_SLANG") || componentType.equals("Client_SLANG_Anonymous");
        }
        return false;
    }

    @Override
    public AbstractMFSession clone() {
        AbstractMFSession result = (AbstractMFSession)super.clone();
        result.owner = this.owner != null ? (ComponentOwner)this.owner.clone() : null;
        result.slSessionData = this.slSessionData != null ? (SLSessionData)this.slSessionData.clone() : null;
        return result;
    }

    public void setInterruptListener(Runnable interruptListener) {
        this.interruptListener = interruptListener;
    }

    public Runnable getInterruptListener() {
        return this.interruptListener;
    }
}

