/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SemanticLexiconManager;
import com.streamscape.slex.SemanticLexiconProcessor;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.system.SystemDSLProvider;
import com.streamscape.tools.console.autocompletion.Completer;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractLexiconProcessor<T>
implements SemanticLexiconProcessor {
    protected SemanticLexiconManager manager;
    protected DSLProvider baseProvider;
    protected List<DSLProvider> providers;
    protected HashMap<String, DSLProvider> providerByOperation = new HashMap();
    protected HashMap<String, List<DSLProvider>> providersByContext = new HashMap();
    protected CompoundCompleter completer = new CompoundCompleter();
    protected static final String DEFAULT_CONTEXT = "SYSTEM$CONTEXT";

    protected AbstractLexiconProcessor(SemanticLexiconManager lexiconManager, DSLComponent<T> component) {
        this.manager = lexiconManager;
        this.providers = lexiconManager != null ? lexiconManager.loadProviders(component) : new ArrayList();
        ArrayList<DSLProvider> defaultProviders = new ArrayList<DSLProvider>();
        this.providersByContext.put(DEFAULT_CONTEXT, defaultProviders);
        for (DSLProvider provider : this.providers) {
            for (String operation : provider.listOperations(null)) {
                String hiddenAlias;
                this.providerByOperation.put(operation, provider);
                String alias = provider.lookupOperation(operation).getAlias();
                if (alias != null) {
                    this.providerByOperation.put(alias, provider);
                }
                if ((hiddenAlias = provider.lookupOperation(operation).getHiddenAlias()) == null) continue;
                this.providerByOperation.put(hiddenAlias, provider);
            }
            defaultProviders.add(provider);
            this.completer.addCompleter(provider);
        }
        this.baseProvider = this.createBaseProvider(component);
        this.registerProvider(this.baseProvider);
        DSLProvider systemProvider = this.createSystemProvider();
        systemProvider.activate(this);
        this.registerProvider(systemProvider);
        this.registerOtherProviders(component);
        this.loadTags();
    }

    protected abstract DSLProvider createBaseProvider(DSLComponent<T> var1);

    protected DSLProvider createSystemProvider() {
        return new SystemDSLProvider(this);
    }

    protected void registerOtherProviders(DSLComponent<T> component) {
    }

    protected void loadTags() {
        for (DSLProvider provider : this.providers) {
            if (!(provider instanceof AbstractDSLProvider)) continue;
            ((AbstractDSLProvider)provider).loadTags();
        }
    }

    protected void saveTags() {
        for (DSLProvider provider : this.providers) {
            if (!(provider instanceof AbstractDSLProvider)) continue;
            ((AbstractDSLProvider)provider).saveTags();
        }
    }

    public Operation getOperation(String operationName) {
        DSLProvider provider = this.providerByOperation.get(AbstractDSLProvider.trimOperation(operationName));
        return provider != null ? provider.lookupOperation(operationName) : null;
    }

    @Override
    public Set<String> listOperations(MFSession session, String pattern) {
        return this.doListOperations(session, pattern, true);
    }

    @Override
    public Set<String> listOperationsByTag(String tag, MFSession session) {
        TreeSet<String> result = new TreeSet<String>();
        for (DSLProvider provider : this.providers) {
            result.addAll(provider.listOperationsByTag(tag, session));
        }
        return result;
    }

    @Override
    public Set<String> listTags(MFSession session) {
        TreeSet<String> result = new TreeSet<String>();
        for (DSLProvider provider : this.providers) {
            result.addAll(provider.listTags(session));
        }
        return result;
    }

    public Operation getVisibleOperation(String operationName, MFSession session) {
        DSLProvider provider = this.providerByOperation.get(AbstractDSLProvider.trimOperation(operationName));
        return provider != null ? provider.getVisibleOperation(operationName, session) : null;
    }

    @Override
    public Set<String> listVisibleOperations(MFSession session, String pattern) {
        return this.doListOperations(session, pattern, false);
    }

    private Set<String> doListOperations(MFSession session, String pattern, boolean needsAll) {
        TreeSet<String> operations = new TreeSet<String>();
        this.fillSessionOperations(operations, session, pattern, needsAll);
        this.fillDefaultOperations(operations, session, pattern, needsAll);
        return operations;
    }

    protected void fillSessionOperations(Set<String> operations, MFSession session, String pattern, boolean needsAll) {
        if (session.getContext() != null) {
            this.fillOperations(operations, session, pattern, needsAll, session.getContext().getComponentType());
        }
    }

    protected void fillDefaultOperations(Set<String> operations, MFSession session, String pattern, boolean needsAll) {
        this.fillOperations(operations, session, pattern, needsAll, DEFAULT_CONTEXT);
    }

    private void fillOperations(Set<String> operations, MFSession session, String pattern, boolean needsAll, String contextType) {
        List<DSLProvider> providers = this.providersByContext.get(contextType);
        if (providers != null) {
            for (DSLProvider provider : providers) {
                operations.addAll(needsAll ? provider.listOperations(pattern) : provider.listVisibleOperations(session, pattern));
            }
        }
    }

    @Override
    public Operation<?> getForeignOperation(String operationName, MFSession session) {
        return this.manager != null ? this.manager.getExportableOperation(operationName, session) : null;
    }

    @Override
    public Set<String> listForeignOperations(MFSession session, String pattern) {
        return this.manager != null ? this.manager.listExportableOperations(session, pattern) : new HashSet<String>();
    }

    @Override
    public Set<String> listForeignOperationsByTag(String tag, MFSession session) {
        return this.manager != null ? this.manager.listExportableOperationsByTag(tag, session) : new HashSet<String>();
    }

    @Override
    public Set<String> listForeignTags(MFSession session) {
        return this.manager != null ? this.manager.listForeignTags(session) : new HashSet();
    }

    @Override
    public Operation<?> getExportableOperation(String operationName, MFSession session) {
        return null;
    }

    @Override
    public Set<String> listExportableOperations(MFSession session, String pattern) {
        return null;
    }

    @Override
    public Set<String> listExportableOperationsByTag(String tag, MFSession session) {
        return null;
    }

    @Override
    public Set<String> listExportableTags(MFSession session) {
        return null;
    }

    private SLStatement parseOperation(String operation, MFSession session) throws Exception {
        List<DSLProvider> providers;
        SLStatement definition;
        if (session != null && session.getContext() != null && (definition = this.parseOperationImpl(operation, session, providers = this.providersByContext.get(session.getContext().getComponentType()))) != null) {
            return definition;
        }
        providers = this.providersByContext.get(DEFAULT_CONTEXT);
        return this.parseOperationImpl(operation, session, providers);
    }

    private SLStatement parseOperationImpl(String operation, MFSession session, List<DSLProvider> providers) throws Exception {
        if (providers != null) {
            for (DSLProvider provider : providers) {
                SLStatement statement = provider.parse(operation, session);
                if (statement == null) continue;
                return statement;
            }
        }
        return null;
    }

    public void registerProvider(DSLProvider provider) {
        this.internalRegisterProvider(provider, DEFAULT_CONTEXT);
    }

    public void registerProvider(DSLProvider provider, String contextType) {
        this.internalRegisterProvider(provider, contextType);
    }

    private void internalRegisterProvider(DSLProvider provider, String contextType) {
        this.providers.add(provider);
        this.completer.addCompleter(provider);
        for (String operation : provider.listOperations(null)) {
            String hiddenAlias;
            String alias;
            if (!this.providerByOperation.containsKey(operation)) {
                this.providerByOperation.put(operation, provider);
            }
            if ((alias = provider.lookupOperation(operation).getAlias()) != null && !this.providerByOperation.containsKey(alias)) {
                this.providerByOperation.put(alias, provider);
            }
            if ((hiddenAlias = provider.lookupOperation(operation).getHiddenAlias()) == null || this.providerByOperation.containsKey(hiddenAlias)) continue;
            this.providerByOperation.put(hiddenAlias, provider);
        }
        this.providersByContext.computeIfAbsent(contextType, k -> new ArrayList()).add(provider);
    }

    @Override
    public SLResponse invoke(String operation, MFSession session, long timeout) throws Exception {
        SLStatement statement = this.parseOperation(operation, session);
        if (statement != null) {
            return this.invoke(statement, session, timeout);
        }
        throw new UnsupportedRequestException();
    }

    @Override
    public SLResponse invoke(SLStatement operation, MFSession session, long timeout) throws Exception {
        DSLProvider provider = this.providerByOperation.get(AbstractDSLProvider.trimOperation(operation.getName()));
        if (provider != null) {
            return provider.invoke(operation, session, timeout);
        }
        throw new UnsupportedRequestException();
    }

    @Override
    public DSLCompletion completeDsl(String command, MFSession session) {
        return this.doCompleteDsl(command, session, this.completer);
    }

    protected DSLCompletion doCompleteDsl(String command, MFSession session, Completer completer) {
        return completer.completeDsl(command, new AbstractDSLProvider.OperationIsVisibleCompleterCondition(session));
    }

    public static DSLCompletion completeRuntimeDsl(String command, MFSession session, SemanticLexiconProcessor processor, DSLCompletion completion) {
        DSLCompletion runtimeCompletion = processor.completeDsl(command, session);
        if (runtimeCompletion != null) {
            for (Suggestion suggestion : runtimeCompletion.getSuggestions()) {
                if (suggestion.getGroup() != null && suggestion.getGroup() != SuggestionGroup.OPERATION) continue;
                suggestion.setGroup(SuggestionGroup.RUNTIME_OPERATION);
            }
            return CompoundCompleter.mergeCompletions(command, completion, runtimeCompletion);
        }
        return completion;
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }
}

