/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex;

import com.streamscape.Trace;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLDefinitionException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.tools.console.autocompletion.AbstractCompleter;
import com.streamscape.tools.console.autocompletion.CompleterCondition;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractDSLProvider<T extends SLCallable>
extends AbstractCompleter
implements DSLProvider<T> {
    private String name;
    protected T callable;
    protected PrefixTree<Operation<T>> prefixTree = new PrefixTree();
    protected PrefixTree<Operation<T>> prefixTreeForLookup = new PrefixTree();
    protected PrefixTree<List<Operation<T>>> operationsByTag = new PrefixTree();
    protected PrefixTree<Operation<T>> prefixTreeForLookupHidden = new PrefixTree();
    protected CompoundCompleter completer = new CompoundCompleter();
    private static OperationTagsMap tagsMap = null;
    private static final String SLTAGS_DIR = "sltags";
    private static final String STROOT_SLTAGS_DIR = "platform/sltags";

    protected AbstractDSLProvider(String name, T callable) {
        this(name, callable, SuggestionGroup.OPERATION);
    }

    protected AbstractDSLProvider(String name, T callable, SuggestionGroup suggestionGroup) {
        this.name = name;
        this.callable = callable;
        this.completer.addCompleter(new PrefixTreeCompleter<Operation<T>>(this.prefixTreeForLookup).setSuggestionGroup(suggestionGroup));
        this.completer.addCompleter(new CommandParameterCompleter<T>(this.prefixTreeForLookup, suggestionGroup));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Operation<T> lookupOperation(String operationName) {
        PrefixTree.Node<Operation<T>> node = this.prefixTree.lookupDataNode(operationName);
        if (node == null) {
            return null;
        }
        return node.getData();
    }

    @Override
    public Operation<T> lookupMoreSuitableOperation(String operationName) {
        PrefixTree.Node<Operation<T>> node = this.prefixTreeForLookup.lookupMoreSuitableDataNode(operationName);
        if (node == null) {
            node = this.prefixTreeForLookupHidden.lookupMoreSuitableDataNode(operationName);
        }
        if (node == null) {
            return null;
        }
        return node.getData();
    }

    @Override
    public boolean hasOperation(String operationName) {
        return this.prefixTree.lookupDataNode(operationName.toLowerCase()) != null;
    }

    @Override
    public Set<String> listOperations(String pattern) {
        final String fPattern = pattern == null ? null : AbstractDSLProvider.trimOperation(pattern);
        final TreeSet<String> result = new TreeSet<String>();
        this.prefixTree.accept(new PrefixTree.DataNodesVisitor<Operation<T>>(this){

            @Override
            public void onDataNode(PrefixTree.Node<Operation<T>> node) {
                Operation operation = node.getData();
                if (operation instanceof AbstractDSLOperation) {
                    for (String definition : operation.getDSLSyntax().getStatementDefinitions()) {
                        if (fPattern != null && !definition.contains(fPattern)) continue;
                        result.add(definition);
                    }
                } else if (fPattern == null || operation.getName().contains(fPattern)) {
                    result.add(operation.getName());
                }
            }
        });
        return result;
    }

    @Override
    public Set<String> listOperationsByTag(String tag, MFSession session) {
        return this.doListOperationsByTag(tag, session, operation -> operation.isVisible(session));
    }

    protected Set<String> doListOperationsByTag(String tag, MFSession session, Predicate<Operation<T>> visibilityPredicate) {
        TreeSet<String> result = new TreeSet<String>();
        PrefixTree.Node<List<Operation<T>>> node = this.operationsByTag.lookupDataNode(tag);
        if (node == null) {
            return result;
        }
        List<Operation<T>> operations = node.getData();
        if (operations == null || operations.size() == 0) {
            return result;
        }
        for (Operation<T> operation : operations) {
            if (!visibilityPredicate.test(operation)) continue;
            if (operation instanceof AbstractDSLOperation) {
                result.addAll(operation.getDSLSyntax().getStatementDefinitions());
            } else {
                result.add(operation.getName());
            }
            if (operation.getAlias() == null) continue;
            result.add(operation.getAlias());
        }
        return result;
    }

    @Override
    public Set<String> listTags(MFSession session) {
        return this.doListTags(session, operation -> operation.isVisible(session));
    }

    protected Set<String> doListTags(MFSession session, final Predicate<Operation<T>> visibilityPredicate) {
        final TreeSet<String> result = new TreeSet<String>();
        this.operationsByTag.accept(new PrefixTree.DataNodesVisitor<List<Operation<T>>>(this){

            @Override
            public void onDataNode(PrefixTree.Node<List<Operation<T>>> node) {
                List operations = node.getData();
                if (operations.stream().anyMatch(visibilityPredicate)) {
                    result.add(node.getDefinition());
                }
            }
        });
        return result;
    }

    @Override
    public Operation<T> getVisibleOperation(String operationName, MFSession session) {
        Operation<T> operation = this.lookupOperation(operationName);
        return operation != null && operation.isVisible(session) ? operation : null;
    }

    @Override
    public Operation<T> getVisibleOperation(SLStatement statement, MFSession session) {
        Operation<T> operation = this.lookupOperation(statement.getName());
        return operation != null && operation.isVisible(session, statement) ? operation : null;
    }

    @Override
    public boolean hasVisibleOperation(String operationName, MFSession session) {
        return this.getVisibleOperation(operationName, session) != null;
    }

    @Override
    public Set<String> listVisibleOperations(MFSession session, String pattern) {
        return this.doListOperations(session, pattern, operation -> operation.isVisible(session));
    }

    protected Set<String> doListOperations(MFSession session, String pattern, final Predicate<Operation<T>> visibilityPredicate) {
        final String fPattern = pattern == null ? null : AbstractDSLProvider.trimOperation(pattern);
        final TreeSet<String> result = new TreeSet<String>();
        this.prefixTree.accept(new PrefixTree.DataNodesVisitor<Operation<T>>(this){

            @Override
            public void onDataNode(PrefixTree.Node<Operation<T>> node) {
                Operation operation = node.getData();
                if (operation instanceof AbstractDSLOperation) {
                    for (String definition : operation.getDSLSyntax().getStatementDefinitions()) {
                        if (fPattern != null && !definition.contains(fPattern) || !visibilityPredicate.test(operation)) continue;
                        result.add(definition);
                    }
                } else if ((fPattern == null || operation.getName().contains(fPattern)) && visibilityPredicate.test(operation)) {
                    result.add(operation.getName());
                }
            }
        });
        return result;
    }

    @Override
    public void activate(T callable) {
        this.prefixTree.accept(new PrefixTree.DataNodesVisitor<Operation<T>>(this, (SLCallable)callable){
            final /* synthetic */ SLCallable val$callable;
            {
                this.val$callable = sLCallable;
            }

            @Override
            public void onDataNode(PrefixTree.Node<Operation<T>> node) {
                node.getData().activate(this.val$callable);
            }
        });
    }

    @Override
    public void registerOperation(Operation<T> operation) {
        if (operation instanceof AbstractDSLOperation) {
            try {
                operation.getDSLSyntax().validate();
            }
            catch (DSLDefinitionException exception) {
                throw new RuntimeException("Syntax of '" + operation.getName() + "' operation is invalid.", exception);
            }
            ((AbstractDSLOperation)operation).setProvider(this);
            for (String definition : operation.getDSLSyntax().getStatementDefinitions()) {
                this.prefixTree.add(definition.toLowerCase(), operation);
            }
            for (String definition : operation.getDSLSyntax().getStatementDefinitionsUpToFirstParameter()) {
                this.prefixTreeForLookup.add(definition.toLowerCase(), operation);
            }
        } else {
            this.prefixTree.add(operation.getName(), operation);
            this.prefixTreeForLookup.add(operation.getName(), operation);
        }
        if (operation.getAlias() != null) {
            this.prefixTree.add(operation.getAlias(), operation);
            this.prefixTreeForLookup.add(operation.getAlias(), operation);
        }
        if (operation.getHiddenAlias() != null) {
            this.prefixTreeForLookupHidden.add(operation.getHiddenAlias(), operation);
        }
        this.addOperationByTag(operation);
    }

    protected void addOperationByTag(Operation<T> operation) {
        Set<String> tags = operation.getTags(null);
        if (tags != null) {
            for (String tag : tags) {
                this.addOperationByTag(tag, operation);
            }
        } else {
            this.addOperationByTag(OperationTag.notag.toString(), operation);
        }
    }

    protected void addOperationByTag(String tag, Operation<T> operation) {
        PrefixTree.Node node = this.operationsByTag.lookupNode(tag);
        if (node == null) {
            node = this.operationsByTag.add(tag, new ArrayList());
        }
        if (node.getData() == null) {
            node.setData(new ArrayList());
        }
        ArrayList operations = (ArrayList)node.getData();
        operations.add(operation);
    }

    public void onTagAdd(String tag, Operation<T> operation) {
        this.addOperationByTag(tag, operation);
    }

    @Override
    public SLStatement parse(String operation, MFSession session) throws ParsingException {
        PrefixTree.Node<Operation<T>> node = this.prefixTreeForLookup.lookupMoreSuitableDataNode(operation);
        if (node == null) {
            node = this.prefixTreeForLookupHidden.lookupMoreSuitableDataNode(operation);
        }
        if (node == null) {
            return null;
        }
        if (!node.getData().isVisible(session) && !node.getData().isVisibleForExecution(session)) {
            return null;
        }
        return node.getData().parse(operation, session);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) {
        Operation operation = this.getVisibleOperation(statement, session);
        if (operation == null) {
            return new SLResponse(new UnsupportedRequestException());
        }
        return SLOperationLogger.invokeWithLoggerWrap(session, () -> operation.invoke(statement, session, timeout), false);
    }

    @Override
    public DSLStatement parseDsl(String operation, MFSession session) throws ParsingException {
        PrefixTree.Node<Operation<T>> node;
        if (((String)operation).length() > 1 && ((String)operation).charAt(0) == '#' && ((String)operation).charAt(1) != ' ') {
            operation = "# " + ((String)operation).substring(1);
        }
        if ((node = this.prefixTreeForLookup.lookupMoreSuitableDataNode((String)operation)) == null) {
            node = this.prefixTreeForLookupHidden.lookupMoreSuitableDataNode((String)operation);
        }
        if (node == null) {
            return null;
        }
        if (!node.getData().isVisible(session)) {
            return null;
        }
        if (!(node.getData() instanceof AbstractDSLOperation)) {
            return null;
        }
        return node.getData().parseDsl((String)operation, session);
    }

    @Override
    public SLResponse invoke(DSLStatement statement, MFSession session) {
        Operation<T> operation = this.lookupOperation(statement.getDefinition());
        if (operation == null) {
            return new SLResponse(new UnsupportedRequestException());
        }
        try {
            return operation.invoke(statement, session);
        }
        catch (Exception exception) {
            Trace.logDebug(this, "WARNING: " + exception.toString());
            return new SLResponse(exception);
        }
    }

    @Override
    public DSLCompletion completeDsl(String command, CompleterCondition condition) {
        if (condition == null) {
            condition = new OperationIsVisibleCompleterCondition(null);
        }
        return this.completer.completeDsl(command, condition);
    }

    public static String trimOperation(String operation) {
        boolean firstSpace = true;
        StringBuilder builder = new StringBuilder();
        char[] cArray = operation.trim().toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (c.equals(Character.valueOf(' ')) && firstSpace) {
                firstSpace = false;
            } else {
                if (c.equals(Character.valueOf(' '))) continue;
                firstSpace = true;
            }
            builder.append(Character.toLowerCase(c.charValue()));
        }
        return builder.toString();
    }

    protected RuntimeContext getRuntimeContext() {
        return null;
    }

    protected String getTagsFilePrefix() {
        return null;
    }

    protected void loadTags() {
        String filePrefix = this.getTagsFilePrefix();
        if (filePrefix != null) {
            OperationTagsMap tagsMap = this.getTagsMap();
            if (tagsMap != null) {
                this.doLoadTags(tagsMap);
            } else if (!this.loadTagsFromRepository()) {
                this.loadTagsFromStroot();
            }
        }
    }

    private boolean loadTagsFromRepository() {
        RuntimeContext context = this.getRuntimeContext();
        if (context != null) {
            String filePath = this.getTagsFilePath(SLTAGS_DIR);
            try {
                RepositoryAccessor accessor = context.getRepositoryAccessor();
                if (accessor.existsFile(SLTAGS_DIR) && accessor.existsFile(filePath)) {
                    this.doLoadTags(new OperationTagsMap((List)context.getXSerializer().deserialize(accessor.getFileContentBytes(filePath))));
                    Trace.logInfo(this, "Operation tags loaded from 'artifacts/" + filePath + "'.");
                    return true;
                }
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Loading operation tags from 'artifacts/" + filePath + "' failed.");
            }
        }
        return false;
    }

    private void loadTagsFromStroot() {
        File file = null;
        if (this.getRuntimeContext() != null) {
            file = new File(this.getRuntimeContext().getSTRootDir(), this.getTagsFilePath(STROOT_SLTAGS_DIR));
        } else if (System.getenv("STROOT") != null) {
            file = new File(System.getenv("STROOT"), this.getTagsFilePath(STROOT_SLTAGS_DIR));
        }
        if (file != null && file.exists()) {
            try {
                this.doLoadTags(new OperationTagsMap((List)Utils.readObjectFromXML(file.getAbsolutePath())));
                Trace.logInfo(this, "Operation tags loaded from '" + file.getAbsolutePath() + "'.");
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Loading operation tags from '" + file.getAbsolutePath() + "' failed.");
            }
        }
    }

    private void doLoadTags(OperationTagsMap tagsMap) {
        this.setTagsMap(tagsMap);
        for (Operation<T> operation : this.getOperations()) {
            Set<String> tags = tagsMap.getTags(operation.getName());
            if (tags == null) continue;
            Set<String> existingTags = operation.getTags(null);
            for (String tag : tags) {
                if (existingTags != null && existingTags.contains(tag)) continue;
                operation.addTag(tag);
            }
        }
    }

    protected void saveTags() {
        String filePrefix = this.getTagsFilePrefix();
        if (filePrefix != null && this.getTagsMap() == null) {
            this.doSaveTags();
        }
    }

    private void doSaveTags() {
        OperationTagsMap tagsMap = new OperationTagsMap();
        List tags = this.getOperations().stream().map(operation -> tagsMap.putTags(operation.getName(), operation.getTags(null))).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            if (!tags.isEmpty()) {
                this.setTagsMap(tagsMap);
                Utils.writeObjectToXML(tags, this.getTagsFilename());
            }
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Saving operation tags to '" + this.getTagsFilename() + "' failed.");
        }
    }

    protected List<Operation<T>> getOperations() {
        final ArrayList<Operation<T>> result = new ArrayList<Operation<T>>();
        this.prefixTree.accept(new PrefixTree.DataNodesVisitor<Operation<T>>(this){

            @Override
            public void onDataNode(PrefixTree.Node<Operation<T>> node) {
                result.add(node.getData());
            }
        });
        return result;
    }

    protected OperationTagsMap getTagsMap() {
        return null;
    }

    protected void setTagsMap(OperationTagsMap tagsMap) {
    }

    private String getTagsFilePath(String dir) {
        return dir + "/" + this.getTagsFilename();
    }

    private String getTagsFilename() {
        return this.getTagsFilePrefix() + "OperationTags.xdo";
    }

    static class CommandParameterCompleter<T extends SLCallable>
    extends AbstractCompleter {
        private PrefixTree<Operation<T>> prefixTree;
        private SuggestionGroup suggestionGroup;

        public CommandParameterCompleter(PrefixTree<Operation<T>> prefixTree, SuggestionGroup suggestionGroup) {
            this.prefixTree = prefixTree;
            this.suggestionGroup = suggestionGroup;
        }

        @Override
        public DSLCompletion completeDsl(String command, CompleterCondition condition) {
            PrefixTree.Node<Operation<T>> node = this.prefixTree.lookupMoreSuitableDataNode(command);
            if (node != null && condition.isGood(node.getData())) {
                return node.getData().completeDsl(command, condition instanceof OperationIsVisibleCompleterCondition ? ((OperationIsVisibleCompleterCondition)condition).getSession() : null, this.suggestionGroup);
            }
            return null;
        }
    }

    static class OperationIsVisibleCompleterCondition
    implements CompleterCondition {
        MFSession session;

        OperationIsVisibleCompleterCondition(MFSession session) {
            this.session = session;
        }

        @Override
        public boolean isGood(Object object) {
            return object instanceof Operation && ((Operation)object).isVisible(this.session);
        }

        public MFSession getSession() {
            return this.session;
        }
    }

    protected static class OperationTagsMap {
        Map<String, Set<String>> tagsByOperation = new HashMap<String, Set<String>>();

        OperationTagsMap() {
        }

        OperationTagsMap(List<OperationTags> operationTags) {
            for (OperationTags tags : operationTags) {
                this.tagsByOperation.put(tags.operation, (Set<String>)(tags.tags != null ? new TreeSet<String>(tags.tags) : new TreeSet()));
            }
        }

        Set<String> getTags(String operationName) {
            return this.tagsByOperation.get(operationName);
        }

        OperationTags putTags(String operationName, Set<String> tags) {
            if (!this.tagsByOperation.containsKey(operationName)) {
                this.tagsByOperation.put(operationName, tags != null ? new TreeSet<String>(tags) : new TreeSet());
                return new OperationTags(operationName, tags);
            }
            return null;
        }
    }

    public static class OperationTags {
        public String operation;
        public List<String> tags;

        OperationTags(String operation, Set<String> tags) {
            this.operation = operation;
            this.tags = tags != null ? new ArrayList<String>(tags) : new ArrayList();
        }
    }
}

