/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.ui.validators;

import com.streamscape.service.osf.config.AbstractServiceConfigurationValidator;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServiceConfigurationValidatorResults;
import com.streamscape.service.osf.config.ServicePropertyType;
import java.util.Hashtable;
import java.util.List;

public class DefaultValidator
extends AbstractServiceConfigurationValidator {
    @Override
    public ServiceConfigurationValidatorResults validate() {
        for (ServiceConfigurationProperty prop : this.getProperties().getProperties()) {
            this.eval(prop);
        }
        return this.getValidationResultSet();
    }

    private void eval(ServiceConfigurationProperty p) {
        ServicePropertyType type = p.getType();
        if (type == ServicePropertyType.LIST) {
            ServiceConfigurationValidatorResults.ValidatorResult result;
            if (!(p instanceof ServiceConfigurationProperty) || !(p.getValue() instanceof List)) {
                result = this.getValidationResultSet().createValidationResult(p.getName());
                result.setType(6);
                result.setMessage("Property Type mismatch. Expected ServicePropertyType.LIST but property is " + p.getClass().getName());
                this.getValidationResultSet().addResult(result);
            }
            if (p.isRequired() && ((List)p.getValue()).size() == 0) {
                result = this.getValidationResultSet().createValidationResult(p.getName());
                result.setType(2);
                result.setMessage("Property is a required property but no list values were specified.");
                this.getValidationResultSet().addResult(result);
            }
        } else if (type == ServicePropertyType.TABLE) {
            ServiceConfigurationValidatorResults.ValidatorResult result;
            if (!(p instanceof ServiceConfigurationProperty) || !(p.getValue() instanceof Hashtable)) {
                result = this.getValidationResultSet().createValidationResult(p.getName());
                result.setType(6);
                result.setMessage("Property Type mismatch. Expected ServicePropertyType.LIST but property is " + p.getClass().getName());
                this.getValidationResultSet().addResult(result);
            }
            if (p.isRequired() && ((Hashtable)p.getValue()).size() == 0) {
                result = this.getValidationResultSet().createValidationResult(p.getName());
                result.setType(2);
                result.setMessage("Property is a required property but no table values were specified.");
                this.getValidationResultSet().addResult(result);
            }
        } else if (p.getType().equals((Object)ServicePropertyType.STRING)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.XML)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.TEXT)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.NUMERIC)) {
            this.checkRequiredProperty(p);
            try {
                Long.parseLong(p.getValue().toString());
                return;
            }
            catch (NumberFormatException nfe) {
                ServiceConfigurationValidatorResults.ValidatorResult result = this.getValidationResultSet().createValidationResult(p.getName());
                result.setType(2);
                result.setMessage("Invalid data format. Property in not a LONG.");
                this.getValidationResultSet().addResult(result);
            }
        } else if (p.getType().equals((Object)ServicePropertyType.DECIMAL)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.BOOLEAN)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.ENUMERATION)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.SQL)) {
            this.checkRequiredProperty(p);
        } else if (p.getType().equals((Object)ServicePropertyType.URL)) {
            this.checkRequiredProperty(p);
        } else {
            ServiceConfigurationValidatorResults.ValidatorResult result = this.getValidationResultSet().createValidationResult(p.getName());
            result.setType(3);
            result.setMessage("Unknown Configuration Property Type: " + String.valueOf((Object)p.getType()) + " for Property '" + p.getName() + "'.");
            this.getValidationResultSet().addResult(result);
        }
    }

    private void checkRequiredProperty(ServiceConfigurationProperty p) {
        ServiceConfigurationValidatorResults.ValidatorResult result;
        if (p.isRequired() && p.getValue().toString().equalsIgnoreCase("")) {
            result = this.getValidationResultSet().createValidationResult(p.getName());
            result.setType(2);
            result.setMessage("Property is a required property but no value was specified.");
            this.getValidationResultSet().addResult(result);
        }
        if (p.isRequired() && p == null) {
            result = this.getValidationResultSet().createValidationResult(p.getName());
            result.setType(2);
            result.setMessage("Property is a required property but a null value was specified.");
            this.getValidationResultSet().addResult(result);
        }
    }
}

