/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.transports;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.service.osf.transports.ConnectionStateValidator;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportFactory;
import java.lang.reflect.Field;
import javax.jms.JMSException;

public class TransportConnectionObserver
implements Runnable {
    private TransportFactory factory = null;
    private TransportConnection observed = null;
    private int reconnectCounter = 0;
    private ConnectionStateValidator validator = null;
    private boolean forceStateCheck = false;
    private FabricThread executor = null;
    private boolean runnable = false;
    private long checkInterval;
    private long reconnectInterval;
    private long currentTimeout;

    public TransportConnectionObserver(TransportFactory factory, TransportConnection connection) {
        this.factory = factory;
        this.observed = connection;
        this.validator = this.initValidator();
        this.checkInterval = factory.getConnectionCheckInterval();
        this.reconnectInterval = factory.getReconnectInterval() > 0L ? factory.getReconnectInterval() : this.checkInterval;
        this.currentTimeout = this.checkInterval;
        this.executor = FabricThreadManager.getInstance().createThread("SVC:Transport.Connection:Observer", "Observer ' " + this.observed.getName() + "'", this);
    }

    private ConnectionStateValidator initValidator() {
        ConnectionStateValidator result = null;
        try {
            result = (ConnectionStateValidator)ClassUtils.createFromClassName((Object)this, this.factory.getConnectionStateValidatorClass(), Thread.currentThread().getContextClassLoader());
            result.init(this.factory, this.observed.getName());
        }
        catch (TransportException error) {
            Trace.logError(this, "Unable to initialize transport connection validator. " + error.getMessage());
            this.observed.raiseException(new TransportException(new JMSException("Connection state validator can not be initialized.")));
        }
        catch (UtilitiesException error) {
            Trace.logError(this, "Unable to initialize transport connection validator. " + error.getMessage());
            this.observed.raiseException(new TransportException(new JMSException("Connection state validator can not be instantiated.")));
        }
        return result;
    }

    public void start() {
        this.runnable = true;
        this.executor.start();
    }

    public void stop() {
        this.runnable = false;
        this.executor.interrupt();
    }

    public void forceStateCheck() {
        this.forceStateCheck = true;
        this.executor.interrupt();
    }

    public boolean isActive() {
        return this.runnable;
    }

    @Override
    public void run() {
        this.reconnectCounter = 0;
        try {
            Class<?> webLogicJmsHelper = Class.forName("oracle.jms.WebLogicHelper");
            Field field = webLogicJmsHelper.getDeclaredField("s_runningInsideWLServer");
            field.setAccessible(true);
            field.set(null, false);
        }
        catch (Throwable webLogicJmsHelper) {
            // empty catch block
        }
        while (this.runnable) {
            if (this.factory.getTransportReconnectRetries() > 0 && this.factory.getTransportReconnectRetries() == this.reconnectCounter) {
                Trace.logDebug(this, "Number of reconnect retries exceeded. Closing connection '" + this.observed.getName() + "'.");
                this.runnable = false;
                break;
            }
            try {
                if (this.observed.getState() == ConnectionState.CLOSED) {
                    Trace.logDebug(this, "Initalizing Connection..");
                    this.observed.connect();
                    this.reconnectCounter = 0;
                    continue;
                }
                if (this.observed.getState() == ConnectionState.RECONNECTING) {
                    Trace.logDebug(this, "Attempting to re-establish connection '" + this.observed.getName() + "'..");
                    ++this.reconnectCounter;
                    Thread.sleep(this.currentTimeout);
                    this.observed.resume();
                    if (this.observed.getState() != ConnectionState.CONNECTED || this.currentTimeout == this.checkInterval) continue;
                    this.currentTimeout = this.checkInterval;
                    continue;
                }
                if (this.observed.getState() != ConnectionState.CONNECTED) continue;
                this.reconnectCounter = 0;
                if (this.validator != null) {
                    this.validator.ping();
                }
                Thread.sleep(this.currentTimeout);
            }
            catch (TransportException ex) {
                Trace.logDebug(this, "Initial Connection Exception: " + ex.getMessage() + ", Suspending Connection..");
                this.observed.suspend();
                if (this.currentTimeout == this.reconnectInterval) continue;
                this.currentTimeout = this.reconnectInterval;
            }
            catch (InterruptedException ex) {
                if (this.forceStateCheck) {
                    this.forceStateCheck = false;
                    continue;
                }
                this.stop();
            }
            catch (Throwable ex) {
                Trace.logException(this, ex, true);
            }
        }
        try {
            this.observed.disconnect();
        }
        catch (TransportException ex) {
            Trace.logDebug(this, "Observer Thread Exception: " + ex.getMessage() + ", Closing Connection.");
        }
        this.executor.stop();
    }
}

