/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.MetricsConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Metrics
extends CloneableDataObject
implements MetricsConfiguration {
    private Hashtable<String, MetricDefinition> metricsTable = new Hashtable();

    @Override
    public void removeMetric(String metricName) throws ServiceConfigurationException {
        if (!StringUtils.validateEventId(metricName)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Invalid metric name '%1$s'.", metricName));
        }
        if (!this.metricsTable.containsKey(metricName)) {
            throw new ServiceConfigurationException("Unknown Metric specified. '" + metricName + "'.");
        }
        this.metricsTable.remove(metricName);
    }

    @Override
    public MetricDefinition getMetric(String metricName) throws ServiceConfigurationException {
        if (!StringUtils.validateEventId(metricName)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Invalid metric name '%1$s'.", metricName));
        }
        if (!this.metricsTable.containsKey(metricName)) {
            throw new ServiceConfigurationException("Unknown Metric specified. '" + metricName + "'.");
        }
        return this.metricsTable.get(metricName);
    }

    @Override
    public List<MetricDefinition> getMetrics() {
        return new ArrayList<MetricDefinition>(this.metricsTable.values());
    }

    @Override
    public boolean hasMetrics() {
        return !this.metricsTable.isEmpty();
    }

    @Override
    public void addMetric(MetricDefinition metric) throws ServiceConfigurationException {
        if (metric == null) {
            throw new ServiceConfigurationException("Null Metric object.");
        }
        if (metric.getName() == null) {
            throw new ServiceConfigurationException("Null Metric name specified.");
        }
        if (metric.getName().equals("")) {
            throw new ServiceConfigurationException("Unknown Metric specified.''.");
        }
        this.metricsTable.put(metric.getName(), metric);
    }

    @Override
    public void removeAllMetrics() {
        this.metricsTable.clear();
    }

    @Override
    public List<String> listMetrics() {
        ArrayList<String> result = new ArrayList<String>(this.metricsTable.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean existsMetric(String metricName) {
        return this.metricsTable.containsKey(metricName);
    }

    @Override
    public Object clone() {
        Metrics result = (Metrics)super.clone();
        if (this.metricsTable != null) {
            for (Map.Entry<String, MetricDefinition> entry : this.metricsTable.entrySet()) {
                result.metricsTable.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return result;
    }
}

