/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.ExceptionsConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExceptionEvents
extends CloneableDataObject
implements ExceptionsConfiguration {
    private List<String> exceptionsTable = new ArrayList<String>();

    @Override
    public void addException(String eventId) throws ServiceConfigurationException {
        if (eventId == null) {
            throw new ServiceConfigurationException("Null eventId specified.");
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        if (this.exceptionsTable.contains(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Duplicate Exception Event ID specified [%1$s].", eventId));
        }
        this.exceptionsTable.add(eventId);
    }

    @Override
    public void removeException(String eventId) throws ServiceConfigurationException {
        if (!this.exceptionsTable.contains(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Specified Exception Event ID [%1$s] does not exist.", eventId));
        }
        this.exceptionsTable.remove(eventId);
    }

    @Override
    public void removeAllExceptions() {
        this.exceptionsTable.clear();
    }

    @Override
    public boolean hasExceptions() {
        return !this.exceptionsTable.isEmpty();
    }

    @Override
    public List<String> listExceptions() {
        ArrayList<String> result = new ArrayList<String>(this.exceptionsTable);
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean existsException(String eventId) {
        return this.exceptionsTable.contains(eventId);
    }

    @Override
    public ExceptionEvents clone() {
        return (ExceptionEvents)super.clone();
    }
}

