/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.EventTriggersConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventTriggers
extends CloneableDataObject
implements EventTriggersConfiguration {
    private List<EventTriggerData> triggers = new ArrayList<EventTriggerData>();

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) {
        if (this.triggers != null) {
            for (EventTriggerData triggerData : this.triggers) {
                if (!triggerData.getName().equalsIgnoreCase(triggerName)) continue;
                return triggerData;
            }
        }
        return null;
    }

    public void addEventTriggerData(EventTriggerData eventTriggerData) throws ServiceConfigurationException {
        if (this.existsEventTrigger(eventTriggerData.getName())) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event trigger %s already exists.", eventTriggerData.getName()));
        }
        if (this.triggers == null) {
            this.triggers = new ArrayList<EventTriggerData>();
        }
        this.triggers.add(eventTriggerData);
    }

    @Override
    public void addEventTrigger(String triggerName) throws ServiceConfigurationException {
        if (triggerName == null) {
            throw new ServiceConfigurationException(ErrorMessages.format("Null trigger specified.", new String[0]));
        }
        if (this.existsEventTrigger(triggerName)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event trigger %s already exists.", triggerName));
        }
        EventTriggerData triggerData = new EventTriggerData(triggerName);
        triggerData.setAutoEnable(false);
        this.addEventTriggerData(triggerData);
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        if (triggerName == null) {
            throw new ServiceConfigurationException(ErrorMessages.format("Null trigger name specified.", new String[0]));
        }
        if (!this.existsEventTrigger(triggerName)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Unknown trigger name specified '%1$s'.", triggerName));
        }
        if (this.triggers != null) {
            ArrayList<EventTriggerData> toRemove = new ArrayList<EventTriggerData>();
            for (EventTriggerData triggerData : this.triggers) {
                if (!triggerData.getName().equals(triggerName)) continue;
                toRemove.add(triggerData);
            }
            this.triggers.removeAll(toRemove);
        }
    }

    @Override
    public void removeAllEventTriggers() {
        if (this.triggers != null) {
            this.triggers.clear();
        }
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        if (this.triggers != null) {
            for (EventTriggerData triggerData : this.triggers) {
                if (!triggerData.getName().equals(triggerName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasEventTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    @Override
    public List<String> listEventTriggers() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.triggers != null) {
            for (EventTriggerData triggerData : this.triggers) {
                result.add(triggerData.getName());
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public Object clone() {
        EventTriggers result = (EventTriggers)super.clone();
        if (this.triggers != null) {
            for (EventTriggerData triggerData : this.triggers) {
                result.triggers.add(triggerData);
            }
        }
        return result;
    }
}

