/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.EventHandlersConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class EventHandlers
extends CloneableDataObject
implements EventHandlersConfiguration {
    private Hashtable<String, EventHandler> handlersTable = new Hashtable();

    @Override
    public void addEventHandler(EventHandler evh) throws ServiceConfigurationException {
        if (evh == null) {
            throw new ServiceConfigurationException("Null Event Handler object specified.");
        }
        if (evh.getHandlerName() == null || evh.getHandlerName().equals("")) {
            throw new ServiceConfigurationException("Null Event Handler name specified.");
        }
        if (this.handlersTable.containsKey(evh.getHandlerName())) {
            throw new ServiceConfigurationException(ErrorMessages.format("Handler name '%1$s' already defined.", evh.getHandlerName()));
        }
        List<String> events = this.listSinkEvents();
        if (events.contains(evh.getRequestEventId())) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event Sink Id [%1$s] already registered.", evh.getRequestEventId()));
        }
        this.handlersTable.put(evh.getHandlerName(), evh);
    }

    @Override
    public void removeEventHandler(String evhName) throws ServiceConfigurationException {
        if (evhName == null) {
            throw new ServiceConfigurationException("Null Event Handler name specified.");
        }
        if (!this.handlersTable.containsKey(evhName)) {
            throw new ServiceConfigurationException("Unknown Event Handler name specified : '" + evhName + "'.");
        }
        this.handlersTable.remove(evhName);
    }

    public void removeEventHandlerByMethodName(String methodName) throws ServiceConfigurationException {
        this.removeEventHandler(this.getEventHandlerByMethodName(methodName).getHandlerName());
    }

    @Override
    public EventHandler getEventHandler(String evhName) throws ServiceConfigurationException {
        if (evhName == null) {
            throw new ServiceConfigurationException("Null Event Handler name specified.");
        }
        if (!this.handlersTable.containsKey(evhName)) {
            throw new ServiceConfigurationException("Unknown Event Handler name specified : '" + evhName + "'.");
        }
        return this.handlersTable.get(evhName);
    }

    public EventHandler getEventHandlerByMethodName(String methodName) throws ServiceConfigurationException {
        if (methodName == null) {
            throw new ServiceConfigurationException("Null method name specified.");
        }
        for (Map.Entry<String, EventHandler> entry : this.handlersTable.entrySet()) {
            if (!entry.getValue().getMethodName().equals(methodName)) continue;
            return entry.getValue();
        }
        throw new ServiceConfigurationException("Unknown Event Handler method name specified : '" + methodName + "'.");
    }

    @Override
    public List<EventHandler> getEventHandlers() {
        return new ArrayList<EventHandler>(this.handlersTable.values());
    }

    @Override
    public List<String> listEventHandlers() {
        ArrayList<String> result = new ArrayList<String>(this.handlersTable.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public void removeAllEventHandlers() {
        this.handlersTable.clear();
    }

    @Override
    public boolean hasEventHandlers() {
        return !this.handlersTable.isEmpty();
    }

    @Override
    public boolean existsEventHandler(String evhName) {
        return this.handlersTable.containsKey(evhName);
    }

    @Override
    public List<String> listSinkEvents() {
        ArrayList<String> result = new ArrayList<String>();
        for (EventHandler handler : this.handlersTable.values()) {
            result.add(handler.getRequestEventId());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean hasSinkEvents() {
        return !this.listSinkEvents().isEmpty();
    }

    @Override
    public Object clone() {
        EventHandlers result = (EventHandlers)super.clone();
        if (this.handlersTable != null) {
            for (Map.Entry<String, EventHandler> entry : this.handlersTable.entrySet()) {
                result.handlersTable.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return result;
    }
}

