/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ConfigurationProperties
implements ServiceConfigurationProperties {
    private Hashtable<String, ServiceConfigurationProperty> propertiesTable = new Hashtable();
    private Vector<String> propertyGroups = new Vector();

    @Override
    public void addProperty(ServiceConfigurationProperty property) throws ServiceConfigurationException {
        if (property == null) {
            throw new ServiceConfigurationException("Null property object.");
        }
        if (property.getName() == null) {
            throw new ServiceConfigurationException("Null property name.");
        }
        this.propertiesTable.put(property.getName(), property);
    }

    @Override
    public void removeProperty(String name) throws ServiceConfigurationException {
        if (!this.propertiesTable.containsKey(name)) {
            throw new ServiceConfigurationException("Unknown property specified: '" + name + "'.");
        }
        this.propertiesTable.remove(name);
    }

    @Override
    public ServiceConfigurationProperty getProperty(String name) throws ServiceConfigurationException {
        if (!this.propertiesTable.containsKey(name)) {
            throw new ServiceConfigurationException("Unknown property specified: '" + name + "'.");
        }
        return this.propertiesTable.get(name);
    }

    @Override
    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.propertiesTable.keySet());
    }

    @Override
    public void removeAllProperties() {
        this.propertiesTable.clear();
    }

    public void setPropertyValue(String name, Object propertyValue) throws ServiceConfigurationException {
        if (!this.propertiesTable.containsKey(name)) {
            throw new ServiceConfigurationException("Unknown property specified: '" + name + "'.");
        }
        this.propertiesTable.get(name).setValue(propertyValue);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertiesTable.containsKey(name);
    }

    @Override
    public List<ServiceConfigurationProperty> getProperties() {
        return new ArrayList<ServiceConfigurationProperty>(this.propertiesTable.values());
    }

    @Override
    public void addPropertyGroup(String groupName) {
        this.propertyGroups.add(groupName);
    }

    @Override
    public void removePropertyGroup(String groupName) {
        this.propertyGroups.remove(groupName);
    }

    @Override
    public boolean existsPropertyGroup(String groupName) {
        return this.propertyGroups.contains(groupName);
    }

    @Override
    public List<String> getPropertyGroups() {
        return new ArrayList<String>(this.propertyGroups);
    }

    @Override
    public List<ServiceConfigurationProperty> getPropertiesForGroup(String groupName) throws ServiceConfigurationException {
        ArrayList<ServiceConfigurationProperty> result = new ArrayList<ServiceConfigurationProperty>();
        for (ServiceConfigurationProperty property : this.propertiesTable.values()) {
            if (!property.getGroup().equals(groupName)) continue;
            result.add(property);
        }
        return result;
    }

    @Override
    public String getDefaultPropertyGroup() {
        return "main.group";
    }

    public Object clone() {
        try {
            ConfigurationProperties result = (ConfigurationProperties)super.clone();
            if (this.propertiesTable != null) {
                for (Map.Entry<String, ServiceConfigurationProperty> entry : this.propertiesTable.entrySet()) {
                    result.propertiesTable.put(entry.getKey(), entry.getValue().clone());
                }
            }
            result.propertyGroups = this.propertyGroups != null ? (Vector)this.propertyGroups.clone() : null;
            return result;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }
}

