/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.AdvisoriesConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class AdvisoryEvents
extends CloneableDataObject
implements AdvisoriesConfiguration {
    private Hashtable<String, StateAdvisoryDefinition> stateAdvisoriesTable = new Hashtable();
    private List<String> advisoriesTable = new ArrayList<String>();

    @Override
    public void addStateAdvisory(StateAdvisoryDefinition advisory) throws ServiceConfigurationException {
        if (advisory == null) {
            throw new ServiceConfigurationException("Null Advisory definition.");
        }
        if (advisory.getName() == null) {
            throw new ServiceConfigurationException("Null Advisory name specified.");
        }
        if (advisory.getName().equals("")) {
            throw new ServiceConfigurationException("Null Advisory name specified.");
        }
        if (this.stateAdvisoriesTable.containsKey(advisory.getName())) {
            throw new ServiceConfigurationException(ErrorMessages.format("Duplicate Advisory name specified '%1$s'.", "State: " + advisory.getName()));
        }
        this.stateAdvisoriesTable.put(advisory.getName(), advisory);
    }

    @Override
    public void addAdvisory(String eventId) throws ServiceConfigurationException {
        Prototype prototype;
        if (eventId == null) {
            throw new ServiceConfigurationException(ErrorMessages.format("Null eventId specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        if (RuntimeState.isActive() && (prototype = RuntimeContext.getInstance().getDatagramPrototypeCache().lookupPrototype(eventId)).getInstanceName().equals("ServiceStateAdvisory")) {
            throw new ServiceConfigurationException(ErrorMessages.format("Invalid Prototype specified [%1$s].", prototype.getInstanceName()));
        }
        if (this.advisoriesTable.contains(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Duplicate Advisory name specified '%1$s'.", eventId));
        }
        this.advisoriesTable.add(eventId);
    }

    @Override
    public void removeAdvisory(String eventId) throws ServiceConfigurationException {
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        if (!this.advisoriesTable.contains(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Unknown Advisory name specified '%1$s'.", eventId));
        }
        if (this.stateAdvisoriesTable.containsKey(eventId)) {
            this.stateAdvisoriesTable.remove(eventId);
        }
        this.advisoriesTable.remove(eventId);
    }

    @Override
    public StateAdvisoryDefinition getStateAdvisoryDefinition(String eventId) throws ServiceConfigurationException {
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        if (!this.stateAdvisoriesTable.containsKey(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Unknown Advisory name specified '%1$s'.", eventId));
        }
        return this.stateAdvisoriesTable.get(eventId);
    }

    @Override
    public void removeAllAdvisories() {
        this.stateAdvisoriesTable.clear();
        this.advisoriesTable.clear();
    }

    @Override
    public boolean hasAdvisories() {
        return !this.advisoriesTable.isEmpty();
    }

    @Override
    public List<String> listAdvisories() {
        ArrayList<String> result = new ArrayList<String>(this.advisoriesTable);
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean existsAdvisory(String eventId) {
        return this.advisoriesTable.contains(eventId);
    }

    @Override
    public List<StateAdvisoryDefinition> getStateAdvisoryDefinitions() {
        return new ArrayList<StateAdvisoryDefinition>(this.stateAdvisoriesTable.values());
    }

    @Override
    public Object clone() {
        AdvisoryEvents result = (AdvisoryEvents)super.clone();
        if (this.stateAdvisoriesTable != null) {
            for (Map.Entry<String, StateAdvisoryDefinition> entry : this.stateAdvisoriesTable.entrySet()) {
                result.stateAdvisoriesTable.put(entry.getKey(), (StateAdvisoryDefinition)entry.getValue().clone());
            }
        }
        result.advisoriesTable = this.advisoriesTable != null ? (List)((ArrayList)this.advisoriesTable).clone() : null;
        return result;
    }
}

