/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.AdvancedPropertiesConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class AdvancedProperties
extends CloneableDataObject
implements AdvancedPropertiesConfiguration {
    private Hashtable<String, ConfigurationProperty> advancedPropertiesTable = new Hashtable();

    @Override
    public void addAdvancedProperty(ConfigurationProperty property) {
        if (property == null) {
            throw new ServiceConfigurationRuntimeException(ErrorMessages.format("Null property object.", new String[0]), false);
        }
        this.advancedPropertiesTable.put(property.getName(), property);
    }

    @Override
    public void removeAdvancedProperty(String propertyName) {
        if (propertyName == null) {
            throw new ServiceConfigurationRuntimeException(ErrorMessages.format("Null property name.", new String[0]), false);
        }
        this.advancedPropertiesTable.remove(propertyName);
    }

    @Override
    public List<ConfigurationProperty> getAdvancedProperties() {
        return new ArrayList<ConfigurationProperty>(this.advancedPropertiesTable.values());
    }

    @Override
    public List<String> listAdvancedProperties() {
        ArrayList<String> result = new ArrayList<String>(this.advancedPropertiesTable.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public String lookupAdvancedProperty(String propertyName) {
        if (propertyName == null) {
            throw new ServiceConfigurationRuntimeException(ErrorMessages.format("Null property name.", new String[0]), false);
        }
        if (!this.existsAdvancedProperty(propertyName)) {
            return null;
        }
        Object value = this.advancedPropertiesTable.get(propertyName).getValue();
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public ConfigurationProperty getAdvancedProperty(String propertyName) {
        return this.advancedPropertiesTable.get(propertyName);
    }

    @Override
    public void removeAllAdvancedProperties() {
        this.advancedPropertiesTable.clear();
    }

    @Override
    public boolean hasAdvancedProperties() {
        return !this.advancedPropertiesTable.isEmpty();
    }

    @Override
    public boolean existsAdvancedProperty(String propertyName) {
        return this.advancedPropertiesTable.containsKey(propertyName);
    }

    @Override
    public Object clone() {
        AdvancedProperties result = (AdvancedProperties)super.clone();
        if (this.advancedPropertiesTable != null) {
            for (Map.Entry<String, ConfigurationProperty> entry : this.advancedPropertiesTable.entrySet()) {
                result.advancedPropertiesTable.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return result;
    }
}

