/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.registry;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.ActionableEventsConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActionableEvents
extends CloneableDataObject
implements ActionableEventsConfiguration {
    private List<String> actionableEventsTable = new ArrayList<String>();

    @Override
    public void addActionableEvent(String eventId) throws ServiceConfigurationException {
        if (eventId == null) {
            throw new ServiceConfigurationException(ErrorMessages.format("Null eventId specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        this.actionableEventsTable.add(eventId);
    }

    @Override
    public void removeActionableEvent(String eventId) throws ServiceConfigurationException {
        if (eventId == null) {
            throw new ServiceConfigurationException(ErrorMessages.format("Null eventId specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        this.actionableEventsTable.remove(eventId);
    }

    @Override
    public List<String> listActionableEvents() {
        ArrayList<String> result = new ArrayList<String>(this.actionableEventsTable);
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean hasActionableEvents() {
        return !this.actionableEventsTable.isEmpty();
    }

    @Override
    public void removeAllActionableEvents() {
        this.actionableEventsTable.clear();
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        return this.actionableEventsTable.contains(eventId);
    }

    @Override
    public Object clone() {
        ActionableEvents result = (ActionableEvents)super.clone();
        result.actionableEventsTable = this.actionableEventsTable != null ? (List)((ArrayList)this.actionableEventsTable).clone() : null;
        return result;
    }

    @Override
    public void setActionableEventId(String oldId, String newId) throws ServiceConfigurationException {
        this.removeActionableEvent(oldId);
        this.addActionableEvent(newId);
    }
}

