/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.globals;

import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.globals.UnresolvedVariableException;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.globals.GlobalVariablesResolver;
import com.streamscape.service.osf.globals.ResolutionException;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GlobalVariablesResolverImpl
implements GlobalVariablesResolver {
    private GlobalVariableCollection variables;
    private MacroProcessor macroProcessor = new MacroProcessor();

    public GlobalVariablesResolverImpl(GlobalVariableCollection variables) {
        this.variables = variables;
    }

    @Override
    public boolean hasGlobalVariableDefinitions(ConfigurationObject sco) {
        for (ServiceConfigurationProperty property : sco.getServiceConfigurationProperties().getProperties()) {
            String value = String.valueOf(property.getValue());
            if (this.getVarPatternPosition(value, 0) < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ServiceConfigurationProperty> getPropertiesWithVariables(ConfigurationObject sco) {
        ArrayList<ServiceConfigurationProperty> propertiesWithVariables = new ArrayList<ServiceConfigurationProperty>();
        for (ServiceConfigurationProperty property : sco.getServiceConfigurationProperties().getProperties()) {
            String value = String.valueOf(property.getValue());
            if (this.getVarPatternPosition(value, 0) < 0) continue;
            propertiesWithVariables.add(property);
        }
        return propertiesWithVariables;
    }

    @Override
    public List<String> getVariableDefinitions(ConfigurationObject sco) {
        HashSet<String> varsUsed = new HashSet<String>();
        block0: for (ServiceConfigurationProperty property : sco.getServiceConfigurationProperties().getProperties()) {
            String value = String.valueOf(property.getValue());
            int varPosition = this.getVarPatternPosition(value, 0);
            while (varPosition >= 0) {
                int varPositionEnd = value.indexOf(125, varPosition + 2);
                String varName = value.substring(varPosition + 2, varPositionEnd);
                if (varName.length() > 0) {
                    varsUsed.add(varName);
                }
                if (varPositionEnd < 0) continue block0;
                varPosition = this.getVarPatternPosition(value, varPositionEnd);
            }
        }
        return new ArrayList<String>(varsUsed);
    }

    private String resolveValue(String value) throws UnresolvedVariableException {
        int varPosition = this.getVarPatternPosition(value, 0);
        if (varPosition >= 0) {
            StringBuffer resolvedValue = new StringBuffer(value.length());
            int varPositionEnd = -1;
            while (varPosition >= 0) {
                resolvedValue.append(value.substring(varPositionEnd + 1, varPosition));
                varPositionEnd = value.indexOf(125, varPosition + 2);
                String varName = value.substring(varPosition + 2, varPositionEnd);
                if (varName.length() > 0) {
                    resolvedValue.append(this.variables.getVariable(varName));
                }
                if (varPositionEnd < 0) break;
                varPosition = this.getVarPatternPosition(value, varPositionEnd);
            }
            if (varPositionEnd >= 0) {
                resolvedValue.append(value.substring(varPositionEnd + 1));
            }
            value = resolvedValue.toString();
        }
        if (MacroProcessor.isMacro(value)) {
            value = this.macroProcessor.process(value);
        }
        return value;
    }

    private void resolveProperty(ServiceConfigurationProperty property) throws UnresolvedVariableException, ServiceConfigurationException {
        JDBCFactoryPropertyValue factory;
        if (property.getValue() instanceof String) {
            String value = (String)property.getRawValue();
            if (MacroProcessor.isMacro(value)) {
                value = this.macroProcessor.processStaticMacro(value);
                property.setValue(value);
            }
        } else if (property.getValue() instanceof List) {
            List listValue = (List)property.getValue();
            for (ServiceConfigurationProperty innerProp : listValue) {
                this.resolveProperty(innerProp);
            }
        } else if (property.getValue() instanceof Hashtable) {
            Hashtable tableValue = (Hashtable)property.getValue();
            for (ServiceConfigurationProperty innerProp : tableValue.values()) {
                this.resolveProperty(innerProp);
            }
        } else if (property.getValue() instanceof ClientFactoryPropertyValue) {
            ClientFactoryPropertyValue factory2 = (ClientFactoryPropertyValue)property.getValue();
            if (MacroProcessor.isMacro(factory2.getFactoryType()) || MacroProcessor.isMacro(factory2.getFactoryName())) {
                ClientFactoryPropertyValue newFactoryValue = new ClientFactoryPropertyValue(this.macroProcessor.processStaticMacro(factory2.getFactoryName()), this.macroProcessor.processStaticMacro(factory2.getFactoryType()));
                property.setValue(newFactoryValue);
            }
        } else if (property.getValue() instanceof TransportFactoryPropertyValue) {
            TransportFactoryPropertyValue factory3 = (TransportFactoryPropertyValue)property.getValue();
            if (MacroProcessor.isMacro(factory3.getFactoryType()) || MacroProcessor.isMacro(factory3.getFactoryName())) {
                TransportFactoryPropertyValue newFactoryValue = new TransportFactoryPropertyValue(this.macroProcessor.processStaticMacro(factory3.getFactoryName()), this.macroProcessor.processStaticMacro(factory3.getFactoryType()));
                property.setValue(newFactoryValue);
            }
        } else if (property.getValue() instanceof JDBCFactoryPropertyValue && (MacroProcessor.isMacro((factory = (JDBCFactoryPropertyValue)property.getValue()).getFactoryType()) || MacroProcessor.isMacro(factory.getFactoryName()))) {
            JDBCFactoryPropertyValue newFactoryValue = new JDBCFactoryPropertyValue(this.macroProcessor.processStaticMacro(factory.getFactoryName()), this.macroProcessor.processStaticMacro(factory.getFactoryType()));
            property.setValue(newFactoryValue);
        }
    }

    @Override
    public ConfigurationObject resolveVariables(ConfigurationObject sco) throws ResolutionException, ServiceConfigurationException, UnresolvedVariableException {
        try {
            XSerializer serializer = XSerializerFactory.getInstance().getDefaultSerializer();
            sco = (ConfigurationObject)serializer.deserialize("ServiceConfiguration", serializer.serialize(sco));
        }
        catch (Exception exception) {
            throw new ResolutionException(exception);
        }
        for (ServiceConfigurationProperty property : sco.getServiceConfigurationProperties().getProperties()) {
            this.resolveProperty(property);
        }
        return sco;
    }

    private int getVarPatternPosition(String s, int start) {
        while (start + 1 < s.length()) {
            if (s.charAt(start) == '$') {
                if (s.charAt(start + 1) == '$') {
                    start += 2;
                    continue;
                }
                if (s.charAt(start + 1) == '{') {
                    if (s.indexOf(125, start + 2) > 0) {
                        return start;
                    }
                    return -1;
                }
            }
            ++start;
        }
        return -1;
    }

    private void resolveProperties(Properties props) throws UnresolvedVariableException {
        Set<Map.Entry<Object, Object>> propEntries = props.entrySet();
        for (Map.Entry<Object, Object> entry : propEntries) {
            if (!(entry.getValue() instanceof String)) continue;
            entry.setValue(this.resolveValue((String)entry.getValue()));
        }
    }

    @Override
    public JDBCFactory resolveVariables(JDBCFactory factory) throws ResolutionException {
        try {
            factory.setCatalog(this.resolveValue(factory.getCatalog()));
            factory.setDefaultUser(this.resolveValue(factory.getDefaultUser()));
            factory.setDefaultPassword(this.resolvePassword(factory.getDefaultPassword()));
            factory.setUrl(this.resolveValue(factory.getUrl()));
            this.resolveProperties(factory.getProperties());
        }
        catch (Exception exception) {
            throw new ResolutionException(exception);
        }
        return factory;
    }

    @Override
    public TransportFactory resolveVariables(TransportFactory factory) throws ResolutionException {
        try {
            factory.setDefaultUrl(this.resolveValue(factory.getDefaultUrl()));
            factory.setDefaultUser(this.resolveValue(factory.getDefaultUser()));
            factory.setDefaultPassword(this.resolvePassword(factory.getDefaultPassword()));
            for (String propName : factory.listFactoryProperties()) {
                factory.setProperty(propName, this.resolveValue(factory.getProperty(propName)));
            }
        }
        catch (Exception exception) {
            throw new ResolutionException(exception);
        }
        return factory;
    }

    @Override
    public ClientFactory resolveVariables(ClientFactory factory) throws ResolutionException {
        try {
            factory.setDefaultUser(this.resolveValue(factory.getDefaultUser()));
            factory.setDefaultPassword(this.resolvePassword(factory.getDefaultPassword()));
            factory.setUrl(this.resolveValue(factory.getUrl()));
            for (String propName : factory.listProperties()) {
                factory.setProperty(propName, this.resolveValue(factory.getProperty(propName)));
            }
        }
        catch (Exception exception) {
            throw new ResolutionException(exception);
        }
        return factory;
    }

    private String resolvePassword(String password) throws UnresolvedVariableException {
        String resolvedPassword = this.resolveValue(password);
        if (!password.equals(resolvedPassword)) {
            resolvedPassword = new String(Base64.decode(resolvedPassword));
        }
        return resolvedPassword;
    }
}

