/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.evh;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationValidator;
import com.streamscape.service.osf.config.ServiceConfigurationValidatorResults;
import com.streamscape.service.osf.evh.EventHandler;
import java.lang.reflect.Method;
import java.util.List;

public class EventHandlerValidator
implements ServiceConfigurationValidator {
    private ConfigurationObject serviceConfig;
    private Service serviceClass;
    private ServiceConfigurationValidatorResults validationResult = new ServiceConfigurationValidatorResults();

    public EventHandlerValidator(ConfigurationObject sco) {
        this.serviceConfig = sco;
    }

    public EventHandlerValidator() {
    }

    public final void setServiceConfiguration(ConfigurationObject sco) {
        this.serviceConfig = sco;
        Trace.logDebug(this, "Event Handler Validator: Service Configuration set for service " + sco.getServiceName());
    }

    public final ConfigurationObject getServiceConfiguration() {
        return this.serviceConfig;
    }

    public final ServiceConfigurationValidatorResults getValidationResultSet() {
        return this.validationResult;
    }

    @Override
    public ServiceConfigurationValidatorResults validate() {
        Trace.logDebug(this, "Event Handler Validator: validate called. Instantiating service class..");
        if (this.serviceConfig == null) {
            ServiceConfigurationValidatorResults.ValidatorResult scoErr = this.validationResult.createValidationResult("ServiceConfigurationObject");
            scoErr.setType(2);
            scoErr.setMessage("Service Configuration Object is null.  Use setServiceConfiguration().");
            this.validationResult.addResult(scoErr);
            Trace.logError(this, "Service Configuration Object is null.  Use setServiceConfiguration().");
            return this.validationResult;
        }
        try {
            this.serviceClass = (Service)ClassUtils.createFromClassName((Object)this, this.serviceConfig.getServiceClassName(), false);
        }
        catch (UtilitiesException ex) {
            ServiceConfigurationValidatorResults.ValidatorResult classErr = this.validationResult.createValidationResult("ServiceClass");
            classErr.setType(2);
            classErr.setMessage("Class Loading Error: " + ex.getMessage());
            this.validationResult.addResult(classErr);
            Trace.logError(this, "Event Handler Validator: Class Loader Exception: " + ex.getMessage());
            return this.validationResult;
        }
        if (this.serviceConfig.isDaemonService()) {
            try {
                this.hasRun();
                return this.validationResult;
            }
            catch (UtilitiesException ex) {
                ServiceConfigurationValidatorResults.ValidatorResult methodErr = this.validationResult.createValidationResult("ServiceConfiguration");
                methodErr.setType(2);
                methodErr.setMessage("Event Handler Configuration Error: " + ex.getMessage());
                this.validationResult.addResult(methodErr);
                Trace.logError(this, "Event Handler Validator Exception: " + ex.getMessage());
                return this.validationResult;
            }
        }
        if (this.serviceConfig.isInterruptableService()) {
            try {
                this.hasCancel();
            }
            catch (UtilitiesException ex) {
                ServiceConfigurationValidatorResults.ValidatorResult methodErr = this.validationResult.createValidationResult("ServiceConfiguration");
                methodErr.setType(2);
                methodErr.setMessage("Event Handler Configuration Error: " + ex.getMessage());
                this.validationResult.addResult(methodErr);
                Trace.logError(this, "Event Handler Validator Exception: " + ex.getMessage());
                return this.validationResult;
            }
        }
        for (EventHandler evh : ((AbstractServiceConfigurationObject)this.serviceConfig).getEventHandlers()) {
            Object outputClass = null;
            Class[] parms = null;
            Trace.logInfo(this, "Validating Event Handler: " + evh.getMethodName());
            try {
                if (!evh.getResponseObjectClass().equals("void")) {
                    Trace.logInfo(this, "Event Handler " + evh.getMethodName() + " has return Class: " + evh.getResponseObjectClass());
                    outputClass = ClassUtils.createFromClassName((Object)this, evh.getResponseObjectClass(), true);
                }
                if (!evh.getRequestObjectClass().equals("null")) {
                    Trace.logInfo(this, "Event Handler " + evh.getMethodName() + " has parameter Class: " + evh.getRequestObjectClass());
                    parms = new Class[1];
                    Object inputClass = ClassUtils.createFromClassName((Object)this, evh.getRequestObjectClass(), true);
                    parms[0] = inputClass.getClass();
                }
                if (this.hasMethod(evh.getMethodName(), parms, outputClass.getClass())) continue;
                ServiceConfigurationValidatorResults.ValidatorResult methodErr = this.validationResult.createValidationResult("ServiceConfiguration");
                methodErr.setType(2);
                methodErr.setMessage("Unsatisfied Event Handler method. Check method signature. : " + evh.getMethodName());
                this.validationResult.addResult(methodErr);
                Trace.logError(this, "Unsatisfied Event Handler method. Check method signature. : " + evh.getMethodName());
            }
            catch (UtilitiesException ex) {
                ServiceConfigurationValidatorResults.ValidatorResult methodErr = this.validationResult.createValidationResult("ServiceConfiguration");
                methodErr.setType(2);
                methodErr.setMessage("Event Handler Validator Exception: " + ex.getMessage());
                this.validationResult.addResult(methodErr);
                Trace.logError(this, "Event Handler Validator Exception: " + ex.getMessage());
            }
        }
        return this.validationResult;
    }

    private boolean hasMethod(String methodName, Class[] parms, Class returnObject) throws UtilitiesException {
        if (this.serviceClass == null) {
            throw new UtilitiesException("Null class object specified.");
        }
        List<Method> methods = ClassUtils.findSatisfiableMethods(this.serviceClass.getClass(), methodName, parms, false, false);
        Trace.logDebug(this, "Found " + methods.size() + " matching " + methodName + " method(s)..");
        Method[] meth = new Method[methods.size()];
        meth = methods.toArray(meth);
        List<Method> results = ClassUtils.findSatisfiableMethodsWithReturnType(meth, returnObject, false);
        Trace.logDebug(this, "Found " + results.size() + " matching " + methodName + " methods w/ return type '" + returnObject.getName() + "'.");
        return results.size() > 0;
    }

    private boolean hasRun() throws UtilitiesException {
        Class[] parms = null;
        if (this.serviceClass == null) {
            throw new UtilitiesException("Null class object specified.");
        }
        List<Method> methods = ClassUtils.findSatisfiableMethods(this.serviceClass.getClass(), "run", parms, false, false);
        Trace.logDebug(this, "Found " + methods.size() + " matching run() methods..");
        Method[] meth = new Method[methods.size()];
        meth = methods.toArray(meth);
        List<Method> results = ClassUtils.findSatisfiableMethodsWithReturnType(meth, null, false);
        Trace.logDebug(this, "Found " + results.size() + " matching run() methods w/ return type 'void'.");
        return results.size() > 0;
    }

    private boolean hasCancel() throws UtilitiesException {
        Class[] parms = null;
        if (this.serviceClass == null) {
            throw new UtilitiesException("Null class object specified.");
        }
        List<Method> methods = ClassUtils.findSatisfiableMethods(this.serviceClass.getClass(), "cancel", parms, false, false);
        Trace.logDebug(this, "Found " + methods.size() + " matching cancel() methods..");
        Method[] meth = new Method[methods.size()];
        meth = methods.toArray(meth);
        List<Method> results = ClassUtils.findSatisfiableMethodsWithReturnType(meth, null, false);
        Trace.logDebug(this, "Found " + results.size() + " matching cancel() methods w/ return type 'void'.");
        return results.size() > 0;
    }
}

